/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpserver.log.log4j;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.nesscomputing.config.Config;
import com.nesscomputing.httpserver.log.LogFieldsModule;
import com.nesscomputing.httpserver.log.log4j.Log4jRequestLog;
import com.nesscomputing.httpserver.log.log4j.Log4jRequestLogModule;
import javax.servlet.http.Cookie;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.joda.time.DateTimeUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class Log4jRequestLogTest
extends EasyMockSupport {
    @Inject
    private Log4jRequestLog log = null;

    @After
    public void tearDown() {
        DateTimeUtils.setCurrentMillisSystem();
    }

    @Test
    public void testLog4jLoggerWorks() {
        Request req = (Request)this.createNiceMock(Request.class);
        Response resp = (Response)this.createNiceMock(Response.class);
        EasyMock.expect((Object)req.getRemoteAddr()).andReturn((Object)"1.2.3.4").anyTimes();
        Cookie[] cookies = new Cookie[]{new Cookie("trumpet-JSON-api-AUTHORIZATION", "omgwtfbbq")};
        EasyMock.expect((Object)req.getCookies()).andReturn((Object)cookies).anyTimes();
        EasyMock.expect((Object)req.getMethod()).andReturn((Object)"GET").anyTimes();
        EasyMock.expect((Object)req.getRequestURL()).andReturn((Object)new StringBuffer("foo")).anyTimes();
        EasyMock.expect((Object)req.getQueryString()).andReturn((Object)"?bar").anyTimes();
        EasyMock.expect((Object)req.getContentLength()).andReturn((Object)42).anyTimes();
        EasyMock.expect((Object)req.getTimeStamp()).andReturn((Object)10000L).anyTimes();
        EasyMock.expect((Object)resp.getStatus()).andReturn((Object)201).anyTimes();
        this.replayAll();
        Config config = Config.getFixedConfig((String[])new String[]{"ness.httpserver.request-log.log4j.enabled", "true"});
        Injector inj = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{this.disableStuff(), new LogFieldsModule(), new Log4jRequestLogModule(config)});
        inj.injectMembers((Object)this);
        Assert.assertNotNull((Object)this.log);
        this.log.log(req, resp);
        this.verifyAll();
    }

    @Test
    public void testLog4jLoggerDisabledByDefault() {
        Config config = Config.getEmptyConfig();
        Injector inj = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{this.disableStuff(), new LogFieldsModule(), new Log4jRequestLogModule(config)});
        Assert.assertNull((Object)inj.getExistingBinding(Key.get(Log4jRequestLog.class)));
    }

    private Module disableStuff() {
        return new Module(){

            public void configure(Binder binder) {
                binder.disableCircularProxies();
                binder.requireExplicitBindings();
            }
        };
    }
}

