/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpserver.jetty;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.nesscomputing.httpserver.HttpServerConfig;
import java.io.File;
import javax.annotation.Nonnull;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ResourceHandler;

public class StaticResourceHandlerProvider
implements Provider<Handler> {
    private final String contextPath;
    private HttpServerConfig httpServerConfig = null;

    public StaticResourceHandlerProvider(@Nonnull String contextPath) {
        Preconditions.checkArgument((contextPath != null ? 1 : 0) != 0, (Object)"context path can not be null (use \"\" for the root!");
        this.contextPath = contextPath;
    }

    @Inject
    void injectHttpServerConfig(HttpServerConfig httpServerConfig) {
        this.httpServerConfig = httpServerConfig;
    }

    public Handler get() {
        Preconditions.checkState((this.httpServerConfig != null ? 1 : 0) != 0, (Object)"http server config was never injected!");
        ContextHandler contextHandler = new ContextHandler();
        contextHandler.setContextPath(this.contextPath);
        File basePath = this.httpServerConfig.getServletContextBasePath();
        Preconditions.checkState((basePath != null ? 1 : 0) != 0, (Object)"no base path was set in the config!");
        Preconditions.checkState((boolean)basePath.exists(), (String)"base path %s does not exist!", (Object[])new Object[]{basePath.getAbsolutePath()});
        Preconditions.checkState((boolean)basePath.canRead(), (String)"base path %s is unreadable!", (Object[])new Object[]{basePath.getAbsolutePath()});
        Preconditions.checkState((boolean)basePath.isDirectory(), (String)"base path %s is not a directory!", (Object[])new Object[]{basePath.getAbsolutePath()});
        contextHandler.setResourceBase(basePath.getAbsolutePath());
        contextHandler.setHandler((Handler)new ResourceHandler());
        return contextHandler;
    }
}

