/*
 * Decompiled with CFR 0.152.
 */
package com.objectsql.support;

import com.objectsql.support.ICommitHandler;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class Commit {
    private PlatformTransactionManager transactionManager;
    private TransactionStatus status;
    private boolean executeSuccess = false;
    private ICommitHandler commitHandler;

    public Commit(Object manager) {
        this.transactionManager = (PlatformTransactionManager)manager;
    }

    public void execute(Runnable runnable) {
        this.execute(runnable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable runnable, ICommitHandler commitHandler) {
        if (runnable == null) {
            return;
        }
        try {
            this.manual();
            runnable.run();
            this.commit();
        }
        catch (Exception e) {
            if (commitHandler != null) {
                commitHandler.handle(e);
            }
        }
        finally {
            if (!this.executeSuccess) {
                this.rollback();
            }
        }
    }

    private void manual() {
        DefaultTransactionDefinition definition = new DefaultTransactionDefinition();
        definition.setPropagationBehavior(3);
        this.status = this.transactionManager.getTransaction((TransactionDefinition)definition);
        this.executeSuccess = false;
    }

    private void commit() {
        if (this.transactionManager != null && this.status != null) {
            this.transactionManager.commit(this.status);
            this.executeSuccess = true;
        }
    }

    private void rollback() {
        if (!this.executeSuccess && this.transactionManager != null && this.status != null) {
            this.transactionManager.rollback(this.status);
        }
    }
}

