/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.syntax.commands;

import com.scriptbasic.context.Context;
import com.scriptbasic.executors.commands.CommandSub;
import com.scriptbasic.interfaces.AnalysisException;
import com.scriptbasic.interfaces.BasicSyntaxException;
import com.scriptbasic.interfaces.LexicalElement;
import com.scriptbasic.spi.Command;
import com.scriptbasic.spi.LeftValueList;
import com.scriptbasic.syntax.commands.AbstractCommandAnalyzer;

public class CommandAnalyzerSub
extends AbstractCommandAnalyzer {
    public CommandAnalyzerSub(Context ctx) {
        super(ctx);
    }

    @Override
    public Command analyze() throws AnalysisException {
        CommandSub node = new CommandSub();
        LexicalElement lexicalElement = this.ctx.lexicalAnalyzer.get();
        if (!lexicalElement.isIdentifier().booleanValue()) {
            throw new BasicSyntaxException("subroutine name has to follow the keyword " + this.getName());
        }
        String subName = lexicalElement.getLexeme();
        node.setSubName(subName);
        if (this.isKeyWord("(")) {
            this.ctx.lexicalAnalyzer.get();
            if (this.isKeyWord(")")) {
                node.setArguments(null);
                this.ctx.lexicalAnalyzer.get();
            } else {
                LeftValueList arguments = this.analyzeSimpleLeftValueList();
                node.setArguments(arguments);
                this.assertKeyWord(")");
            }
        } else {
            node.setArguments(null);
        }
        this.pushNode(node);
        this.consumeEndOfLine();
        return node;
    }
}

