/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.syntax;

import com.scriptbasic.exceptions.LexicalException;
import com.scriptbasic.interfaces.AnalysisException;
import com.scriptbasic.interfaces.BasicSyntaxException;
import com.scriptbasic.interfaces.LexicalAnalyzer;
import com.scriptbasic.interfaces.LexicalElement;
import com.scriptbasic.interfaces.NestedStructure;
import com.scriptbasic.interfaces.NestedStructureHouseKeeper;
import com.scriptbasic.log.Logger;
import com.scriptbasic.log.LoggerFactory;
import com.scriptbasic.utility.SyntaxExceptionUtility;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Stack;

public abstract class AbstractNestedStructureHouseKeeper
implements NestedStructureHouseKeeper {
    private static final Logger LOG = LoggerFactory.getLogger();
    private static final Structure MATCH_NOTHING = new Structure(){

        @Override
        public <T> boolean match(Class<T> expectedClass) {
            return false;
        }
    };
    private final Stack<Structure> stack = new Stack();
    private final LexicalAnalyzer analyzer;
    private boolean stackIsHealthy = true;
    private final Stack<NestedStructureHouseKeeper.EndOfStatementProcessor> endOfStatementProcessors = new Stack();

    protected AbstractNestedStructureHouseKeeper(LexicalAnalyzer analyzer) {
        this.analyzer = analyzer;
    }

    @Override
    public void push(NestedStructure element) {
        this.push(element.getClass(), element);
    }

    protected boolean isStackIsHealthy() {
        return this.stackIsHealthy;
    }

    @Override
    public void push(Class<?> klass, NestedStructure element) {
        Structure stackFrame = new Structure();
        stackFrame.setElementType(klass);
        stackFrame.setPushedElement(element);
        this.stack.push(stackFrame);
    }

    @Override
    public <T extends NestedStructure> T pop(Class<T> expectedClass) throws AnalysisException {
        Structure stackFrame;
        Structure structure = stackFrame = this.stack.isEmpty() ? MATCH_NOTHING : this.stack.peek();
        if (!stackFrame.match(expectedClass)) {
            this.stackIsHealthy = false;
            BasicSyntaxException se = new BasicSyntaxException("Bad nested structures");
            try {
                se.setLocation(this.analyzer.peek());
            }
            catch (LexicalException e) {
                LOG.error("There was an error when trying to fetch the current source location", e);
            }
            throw se;
        }
        this.stack.pop();
        return (T)stackFrame.getPushedElement();
    }

    @Override
    public void checkFinalState() throws AnalysisException {
        if (this.stack.size() > 0) {
            throw new BasicSyntaxException("There is at least one opened block on the stack. Block is not properly closed.");
        }
        if (this.endOfStatementProcessors.size() > 0) {
            throw new BasicSyntaxException("There is at least one unfinished statement.");
        }
    }

    @Override
    public void consumeEndOfStatement() throws AnalysisException {
        LexicalElement le;
        int numOfProcessors = this.endOfStatementProcessors.size();
        if (numOfProcessors > 0) {
            ArrayList<NestedStructureHouseKeeper.EndOfStatementProcessor> processors = new ArrayList<NestedStructureHouseKeeper.EndOfStatementProcessor>(numOfProcessors);
            ListIterator iter = this.endOfStatementProcessors.listIterator(this.endOfStatementProcessors.size());
            while (iter.hasPrevious()) {
                processors.add((NestedStructureHouseKeeper.EndOfStatementProcessor)iter.previous());
            }
            for (NestedStructureHouseKeeper.EndOfStatementProcessor processor : processors) {
                NestedStructureHouseKeeper.EndOfStatementResult result = processor.consumeEndOfStatement();
                if (result != NestedStructureHouseKeeper.EndOfStatementResult.CONSUMED) continue;
                return;
            }
        }
        if ((le = this.analyzer.get()) != null && !le.isLineTerminator().booleanValue() && !le.isStatementSeparator().booleanValue()) {
            SyntaxExceptionUtility.throwSyntaxException("There are extra characters following the expression.", le);
        }
    }

    @Override
    public void pushEndOfStatementProcessor(NestedStructureHouseKeeper.EndOfStatementProcessor endOfStatementProcessor) {
        this.endOfStatementProcessors.push(endOfStatementProcessor);
    }

    @Override
    public NestedStructureHouseKeeper.EndOfStatementProcessor popEndOfStatementProcessor() {
        return this.endOfStatementProcessors.pop();
    }

    protected static class Structure {
        private Class<?> elementType;
        private NestedStructure pushedElement;

        protected Structure() {
        }

        public Class<?> getElementType() {
            return this.elementType;
        }

        public void setElementType(Class<?> elementType) {
            this.elementType = elementType;
        }

        public NestedStructure getPushedElement() {
            return this.pushedElement;
        }

        public void setPushedElement(NestedStructure pushedElement) {
            this.pushedElement = pushedElement;
        }

        public <T> boolean match(Class<T> expectedClass) {
            return expectedClass.isAssignableFrom(this.getElementType());
        }
    }
}

