/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.syntax.commands;

import com.scriptbasic.context.Context;
import com.scriptbasic.executors.commands.CommandMethod;
import com.scriptbasic.interfaces.AnalysisException;
import com.scriptbasic.interfaces.Expression;
import com.scriptbasic.interfaces.ExpressionList;
import com.scriptbasic.spi.Command;
import com.scriptbasic.syntax.commands.AbstractCommandAnalyzer;
import com.scriptbasic.utility.ExpressionUtility;
import com.scriptbasic.utility.KlassUtility;
import com.scriptbasic.utility.LexUtility;
import java.util.ArrayList;

public class CommandAnalyzerMethod
extends AbstractCommandAnalyzer {
    public CommandAnalyzerMethod(Context ctx) {
        super(ctx);
    }

    @Override
    public Command analyze() throws AnalysisException {
        String methodName = this.getMethodName();
        LexUtility.checkLexeme(this.ctx.lexicalAnalyzer, "from", "Keyword 'FROM' is missing in command 'METHOD'");
        String className = this.getClassName();
        LexUtility.checkLexeme(this.ctx.lexicalAnalyzer, "is", "Keyword 'IS' is missing in command 'METHOD'");
        LexUtility.checkLexeme(this.ctx.lexicalAnalyzer, "(", "'(' is missing in command 'METHOD' after the keyword 'IS'");
        ArrayList<Class<?>> argClasses = this.getArgClasses();
        LexUtility.checkLexeme(this.ctx.lexicalAnalyzer, ")", "')' is missing in command 'METHOD'");
        String alias = this.getAlias(methodName);
        CommandMethod node = new CommandMethod();
        node.setArgumentTypes(argClasses.toArray(new Class[0]));
        node.setKlass(KlassUtility.forNameEx(className));
        node.setMethodName(methodName);
        node.setAlias(alias);
        this.consumeEndOfStatement();
        return node;
    }

    private String getAlias(String methodName) throws AnalysisException {
        String alias;
        if (LexUtility.isLexeme(this.ctx.lexicalAnalyzer, "use")) {
            LexUtility.checkLexeme(this.ctx.lexicalAnalyzer, "as", "Keyword 'AS' is missung after 'USE in command 'METHOD'");
            alias = this.getString();
        } else {
            alias = methodName;
        }
        return alias;
    }

    private String getClassName() throws AnalysisException {
        return this.getString();
    }

    private String getString() throws AnalysisException {
        return ExpressionUtility.convertToString(this.analyzeExpression());
    }

    private String getMethodName() throws AnalysisException {
        return this.getString();
    }

    private ArrayList<Class<?>> getArgClasses() throws AnalysisException {
        ExpressionList argExpressions = (ExpressionList)this.ctx.expressionListAnalyzer.analyze();
        ArrayList argClasses = new ArrayList();
        for (Expression expression : argExpressions) {
            String argClassName = ExpressionUtility.convertToString(expression);
            argClasses.add(KlassUtility.forNameEx(argClassName));
        }
        return argClasses;
    }
}

