/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java;

import com.stackone.stackone_client_java.Accounts;
import com.stackone.stackone_client_java.Ats;
import com.stackone.stackone_client_java.ConnectSessions;
import com.stackone.stackone_client_java.Connectors;
import com.stackone.stackone_client_java.Crm;
import com.stackone.stackone_client_java.Hris;
import com.stackone.stackone_client_java.Iam;
import com.stackone.stackone_client_java.Lms;
import com.stackone.stackone_client_java.Marketing;
import com.stackone.stackone_client_java.Proxy;
import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.SecuritySource;
import com.stackone.stackone_client_java.models.components.Security;
import com.stackone.stackone_client_java.utils.HTTPClient;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.SpeakeasyHTTPClient;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Map;
import java.util.Optional;

public class StackOne {
    public static final String[] SERVERS = new String[]{"https://api.stackone.com"};
    private final ConnectSessions connectSessions;
    private final Accounts accounts;
    private final Connectors connectors;
    private final Proxy proxy;
    private final Hris hris;
    private final Ats ats;
    private final Crm crm;
    private final Iam iam;
    private final Marketing marketing;
    private final Lms lms;
    private final SDKConfiguration sdkConfiguration;

    public ConnectSessions connectSessions() {
        return this.connectSessions;
    }

    public Accounts accounts() {
        return this.accounts;
    }

    public Connectors connectors() {
        return this.connectors;
    }

    public Proxy proxy() {
        return this.proxy;
    }

    public Hris hris() {
        return this.hris;
    }

    public Ats ats() {
        return this.ats;
    }

    public Crm crm() {
        return this.crm;
    }

    public Iam iam() {
        return this.iam;
    }

    public Marketing marketing() {
        return this.marketing;
    }

    public Lms lms() {
        return this.lms;
    }

    public static Builder builder() {
        return new Builder();
    }

    private StackOne(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.connectSessions = new ConnectSessions(sdkConfiguration);
        this.accounts = new Accounts(sdkConfiguration);
        this.connectors = new Connectors(sdkConfiguration);
        this.proxy = new Proxy(sdkConfiguration);
        this.hris = new Hris(sdkConfiguration);
        this.ats = new Ats(sdkConfiguration);
        this.crm = new Crm(sdkConfiguration);
        this.iam = new Iam(sdkConfiguration);
        this.marketing = new Marketing(sdkConfiguration);
        this.lms = new Lms(sdkConfiguration);
        this.sdkConfiguration.initialize();
    }

    public static class Builder {
        private final SDKConfiguration sdkConfiguration = new SDKConfiguration();

        private Builder() {
        }

        public Builder client(HTTPClient client) {
            this.sdkConfiguration.defaultClient = client;
            return this;
        }

        public Builder security(Security security) {
            this.sdkConfiguration.securitySource = SecuritySource.of(security);
            return this;
        }

        public Builder securitySource(SecuritySource securitySource) {
            this.sdkConfiguration.securitySource = securitySource;
            return this;
        }

        public Builder serverURL(String serverUrl) {
            this.sdkConfiguration.serverUrl = serverUrl;
            return this;
        }

        public Builder serverURL(String serverUrl, Map<String, String> params) {
            this.sdkConfiguration.serverUrl = Utils.templateUrl(serverUrl, params);
            return this;
        }

        public Builder serverIndex(int serverIdx) {
            this.sdkConfiguration.serverIdx = serverIdx;
            this.sdkConfiguration.serverUrl = SERVERS[serverIdx];
            return this;
        }

        public Builder retryConfig(RetryConfig retryConfig) {
            this.sdkConfiguration.retryConfig = Optional.of(retryConfig);
            return this;
        }

        public StackOne build() {
            if (this.sdkConfiguration.defaultClient == null) {
                this.sdkConfiguration.defaultClient = new SpeakeasyHTTPClient();
            }
            if (this.sdkConfiguration.securitySource == null) {
                this.sdkConfiguration.securitySource = SecuritySource.of(null);
            }
            if (this.sdkConfiguration.serverUrl == null || this.sdkConfiguration.serverUrl.isBlank()) {
                this.sdkConfiguration.serverUrl = SERVERS[0];
                this.sdkConfiguration.serverIdx = 0;
            }
            if (this.sdkConfiguration.serverUrl.endsWith("/")) {
                this.sdkConfiguration.serverUrl = this.sdkConfiguration.serverUrl.substring(0, this.sdkConfiguration.serverUrl.length() - 1);
            }
            return new StackOne(this.sdkConfiguration);
        }
    }
}

