/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.NoteResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AtsGetCandidateNoteResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends NoteResult> noteResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public AtsGetCandidateNoteResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends NoteResult> noteResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(noteResult, "noteResult");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.noteResult = noteResult;
        this.headers = headers;
    }

    public AtsGetCandidateNoteResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<NoteResult> noteResult() {
        return this.noteResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public AtsGetCandidateNoteResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AtsGetCandidateNoteResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AtsGetCandidateNoteResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AtsGetCandidateNoteResponse withNoteResult(NoteResult noteResult) {
        Utils.checkNotNull(noteResult, "noteResult");
        this.noteResult = Optional.ofNullable(noteResult);
        return this;
    }

    public AtsGetCandidateNoteResponse withNoteResult(Optional<? extends NoteResult> noteResult) {
        Utils.checkNotNull(noteResult, "noteResult");
        this.noteResult = noteResult;
        return this;
    }

    public AtsGetCandidateNoteResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsGetCandidateNoteResponse other = (AtsGetCandidateNoteResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.noteResult, other.noteResult) && Objects.deepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.noteResult, this.headers);
    }

    public String toString() {
        return Utils.toString(AtsGetCandidateNoteResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "noteResult", this.noteResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends NoteResult> noteResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder noteResult(NoteResult noteResult) {
            Utils.checkNotNull(noteResult, "noteResult");
            this.noteResult = Optional.ofNullable(noteResult);
            return this;
        }

        public Builder noteResult(Optional<? extends NoteResult> noteResult) {
            Utils.checkNotNull(noteResult, "noteResult");
            this.noteResult = noteResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AtsGetCandidateNoteResponse build() {
            return new AtsGetCandidateNoteResponse(this.contentType, this.statusCode, this.rawResponse, this.noteResult, this.headers);
        }
    }
}

