/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class PhoneNumber {

    /**
     * Type of phone number
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("type")
    private JsonNullable<? extends PhoneNumberType> type;

    /**
     * Phone number string
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("phone")
    private JsonNullable<String> phone;

    @JsonCreator
    public PhoneNumber(
            @JsonProperty("type") JsonNullable<? extends PhoneNumberType> type,
            @JsonProperty("phone") JsonNullable<String> phone) {
        Utils.checkNotNull(type, "type");
        Utils.checkNotNull(phone, "phone");
        this.type = type;
        this.phone = phone;
    }
    
    public PhoneNumber() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Type of phone number
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<PhoneNumberType> type() {
        return (JsonNullable<PhoneNumberType>) type;
    }

    /**
     * Phone number string
     */
    @JsonIgnore
    public JsonNullable<String> phone() {
        return phone;
    }

    public final static Builder builder() {
        return new Builder();
    }

    /**
     * Type of phone number
     */
    public PhoneNumber withType(PhoneNumberType type) {
        Utils.checkNotNull(type, "type");
        this.type = JsonNullable.of(type);
        return this;
    }

    /**
     * Type of phone number
     */
    public PhoneNumber withType(JsonNullable<? extends PhoneNumberType> type) {
        Utils.checkNotNull(type, "type");
        this.type = type;
        return this;
    }

    /**
     * Phone number string
     */
    public PhoneNumber withPhone(String phone) {
        Utils.checkNotNull(phone, "phone");
        this.phone = JsonNullable.of(phone);
        return this;
    }

    /**
     * Phone number string
     */
    public PhoneNumber withPhone(JsonNullable<String> phone) {
        Utils.checkNotNull(phone, "phone");
        this.phone = phone;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PhoneNumber other = (PhoneNumber) o;
        return 
            Objects.deepEquals(this.type, other.type) &&
            Objects.deepEquals(this.phone, other.phone);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            type,
            phone);
    }
    
    @Override
    public String toString() {
        return Utils.toString(PhoneNumber.class,
                "type", type,
                "phone", phone);
    }
    
    public final static class Builder {
 
        private JsonNullable<? extends PhoneNumberType> type = JsonNullable.undefined();
 
        private JsonNullable<String> phone = JsonNullable.undefined();  
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Type of phone number
         */
        public Builder type(PhoneNumberType type) {
            Utils.checkNotNull(type, "type");
            this.type = JsonNullable.of(type);
            return this;
        }

        /**
         * Type of phone number
         */
        public Builder type(JsonNullable<? extends PhoneNumberType> type) {
            Utils.checkNotNull(type, "type");
            this.type = type;
            return this;
        }

        /**
         * Phone number string
         */
        public Builder phone(String phone) {
            Utils.checkNotNull(phone, "phone");
            this.phone = JsonNullable.of(phone);
            return this;
        }

        /**
         * Phone number string
         */
        public Builder phone(JsonNullable<String> phone) {
            Utils.checkNotNull(phone, "phone");
            this.phone = phone;
            return this;
        }
        
        public PhoneNumber build() {
            return new PhoneNumber(
                type,
                phone);
        }
    }
}

