/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.RejectedReasonResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AtsGetRejectedReasonResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends RejectedReasonResult> rejectedReasonResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public AtsGetRejectedReasonResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends RejectedReasonResult> rejectedReasonResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(rejectedReasonResult, "rejectedReasonResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.rejectedReasonResult = rejectedReasonResult;
        this.headers = headers;
    }

    public AtsGetRejectedReasonResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<RejectedReasonResult> rejectedReasonResult() {
        return this.rejectedReasonResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AtsGetRejectedReasonResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AtsGetRejectedReasonResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AtsGetRejectedReasonResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AtsGetRejectedReasonResponse withRejectedReasonResult(RejectedReasonResult rejectedReasonResult) {
        Utils.checkNotNull(rejectedReasonResult, "rejectedReasonResult");
        this.rejectedReasonResult = Optional.ofNullable(rejectedReasonResult);
        return this;
    }

    public AtsGetRejectedReasonResponse withRejectedReasonResult(Optional<? extends RejectedReasonResult> rejectedReasonResult) {
        Utils.checkNotNull(rejectedReasonResult, "rejectedReasonResult");
        this.rejectedReasonResult = rejectedReasonResult;
        return this;
    }

    public AtsGetRejectedReasonResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsGetRejectedReasonResponse other = (AtsGetRejectedReasonResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.rejectedReasonResult, other.rejectedReasonResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.rejectedReasonResult, this.headers);
    }

    public String toString() {
        return Utils.toString(AtsGetRejectedReasonResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "rejectedReasonResult", this.rejectedReasonResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends RejectedReasonResult> rejectedReasonResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder rejectedReasonResult(RejectedReasonResult rejectedReasonResult) {
            Utils.checkNotNull(rejectedReasonResult, "rejectedReasonResult");
            this.rejectedReasonResult = Optional.ofNullable(rejectedReasonResult);
            return this;
        }

        public Builder rejectedReasonResult(Optional<? extends RejectedReasonResult> rejectedReasonResult) {
            Utils.checkNotNull(rejectedReasonResult, "rejectedReasonResult");
            this.rejectedReasonResult = rejectedReasonResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AtsGetRejectedReasonResponse build() {
            return new AtsGetRejectedReasonResponse(this.contentType, this.statusCode, this.rawResponse, this.rejectedReasonResult, this.headers);
        }
    }
}

