/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.TicketingUsersPaginated;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TicketingListUsersResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends TicketingUsersPaginated> ticketingUsersPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public TicketingListUsersResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends TicketingUsersPaginated> ticketingUsersPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(ticketingUsersPaginated, "ticketingUsersPaginated");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.ticketingUsersPaginated = ticketingUsersPaginated;
        this.headers = headers;
    }

    public TicketingListUsersResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<TicketingUsersPaginated> ticketingUsersPaginated() {
        return this.ticketingUsersPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public TicketingListUsersResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public TicketingListUsersResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public TicketingListUsersResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public TicketingListUsersResponse withTicketingUsersPaginated(TicketingUsersPaginated ticketingUsersPaginated) {
        Utils.checkNotNull(ticketingUsersPaginated, "ticketingUsersPaginated");
        this.ticketingUsersPaginated = Optional.ofNullable(ticketingUsersPaginated);
        return this;
    }

    public TicketingListUsersResponse withTicketingUsersPaginated(Optional<? extends TicketingUsersPaginated> ticketingUsersPaginated) {
        Utils.checkNotNull(ticketingUsersPaginated, "ticketingUsersPaginated");
        this.ticketingUsersPaginated = ticketingUsersPaginated;
        return this;
    }

    public TicketingListUsersResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TicketingListUsersResponse other = (TicketingListUsersResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.ticketingUsersPaginated, other.ticketingUsersPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.ticketingUsersPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(TicketingListUsersResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "ticketingUsersPaginated", this.ticketingUsersPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends TicketingUsersPaginated> ticketingUsersPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder ticketingUsersPaginated(TicketingUsersPaginated ticketingUsersPaginated) {
            Utils.checkNotNull(ticketingUsersPaginated, "ticketingUsersPaginated");
            this.ticketingUsersPaginated = Optional.ofNullable(ticketingUsersPaginated);
            return this;
        }

        public Builder ticketingUsersPaginated(Optional<? extends TicketingUsersPaginated> ticketingUsersPaginated) {
            Utils.checkNotNull(ticketingUsersPaginated, "ticketingUsersPaginated");
            this.ticketingUsersPaginated = ticketingUsersPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public TicketingListUsersResponse build() {
            return new TicketingListUsersResponse(this.contentType, this.statusCode, this.rawResponse, this.ticketingUsersPaginated, this.headers);
        }
    }
}

