/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.components.UnifiedUploadRequestDto;
import com.stackone.stackone_client_java.models.operations.DocumentsUploadFileRequest;
import com.stackone.stackone_client_java.models.operations.DocumentsUploadFileResponse;
import com.stackone.stackone_client_java.operations.DocumentsUploadFile;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class DocumentsUploadFileRequestBuilder {
    private String xAccountId;
    private Optional<String> xStackoneApiSessionToken = Optional.empty();
    private UnifiedUploadRequestDto unifiedUploadRequestDto;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;
    private final Headers _headers = new Headers();

    public DocumentsUploadFileRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public DocumentsUploadFileRequestBuilder xAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public DocumentsUploadFileRequestBuilder xStackoneApiSessionToken(String xStackoneApiSessionToken) {
        Utils.checkNotNull(xStackoneApiSessionToken, "xStackoneApiSessionToken");
        this.xStackoneApiSessionToken = Optional.of(xStackoneApiSessionToken);
        return this;
    }

    public DocumentsUploadFileRequestBuilder xStackoneApiSessionToken(Optional<String> xStackoneApiSessionToken) {
        Utils.checkNotNull(xStackoneApiSessionToken, "xStackoneApiSessionToken");
        this.xStackoneApiSessionToken = xStackoneApiSessionToken;
        return this;
    }

    public DocumentsUploadFileRequestBuilder unifiedUploadRequestDto(UnifiedUploadRequestDto unifiedUploadRequestDto) {
        Utils.checkNotNull(unifiedUploadRequestDto, "unifiedUploadRequestDto");
        this.unifiedUploadRequestDto = unifiedUploadRequestDto;
        return this;
    }

    public DocumentsUploadFileRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public DocumentsUploadFileRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private DocumentsUploadFileRequest buildRequest() {
        DocumentsUploadFileRequest request = new DocumentsUploadFileRequest(this.xAccountId, this.xStackoneApiSessionToken, this.unifiedUploadRequestDto);
        return request;
    }

    public DocumentsUploadFileResponse call() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        DocumentsUploadFile.Sync operation = new DocumentsUploadFile.Sync(this.sdkConfiguration, options, this._headers);
        DocumentsUploadFileRequest request = this.buildRequest();
        return (DocumentsUploadFileResponse)operation.handleResponse(operation.doRequest(request));
    }
}

