/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java;

import com.stackone.stackone_client_java.Connectors;
import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.StackoneGetConnectorMetaRequest;
import com.stackone.stackone_client_java.models.operations.StackoneListConnectorsMetaRequest;
import com.stackone.stackone_client_java.models.operations.async.StackoneGetConnectorMetaRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.StackoneGetConnectorMetaResponse;
import com.stackone.stackone_client_java.models.operations.async.StackoneListConnectorsMetaRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.StackoneListConnectorsMetaResponse;
import com.stackone.stackone_client_java.operations.StackoneGetConnectorMeta;
import com.stackone.stackone_client_java.operations.StackoneListConnectorsMeta;
import com.stackone.stackone_client_java.utils.Headers;
import com.stackone.stackone_client_java.utils.Options;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.openapitools.jackson.nullable.JsonNullable;

public class AsyncConnectors {
    private static final Headers _headers = Headers.EMPTY;
    private final SDKConfiguration sdkConfiguration;
    private final Connectors syncSDK;

    AsyncConnectors(Connectors syncSDK, SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.syncSDK = syncSDK;
    }

    public Connectors sync() {
        return this.syncSDK;
    }

    public StackoneListConnectorsMetaRequestBuilder listConnectorsMeta() {
        return new StackoneListConnectorsMetaRequestBuilder(this.sdkConfiguration);
    }

    public CompletableFuture<StackoneListConnectorsMetaResponse> listConnectorsMetaDirect() {
        return this.listConnectorsMeta((JsonNullable<String>)JsonNullable.undefined(), Optional.empty());
    }

    public CompletableFuture<StackoneListConnectorsMetaResponse> listConnectorsMeta(JsonNullable<String> include, Optional<Options> options) {
        StackoneListConnectorsMetaRequest request = StackoneListConnectorsMetaRequest.builder().include(include).build();
        StackoneListConnectorsMeta.Async operation = new StackoneListConnectorsMeta.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), _headers);
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }

    public StackoneGetConnectorMetaRequestBuilder getConnectorMeta() {
        return new StackoneGetConnectorMetaRequestBuilder(this.sdkConfiguration);
    }

    public CompletableFuture<StackoneGetConnectorMetaResponse> getConnectorMeta(String provider) {
        return this.getConnectorMeta(provider, (JsonNullable<String>)JsonNullable.undefined(), Optional.empty());
    }

    public CompletableFuture<StackoneGetConnectorMetaResponse> getConnectorMeta(String provider, JsonNullable<String> include, Optional<Options> options) {
        StackoneGetConnectorMetaRequest request = StackoneGetConnectorMetaRequest.builder().provider(provider).include(include).build();
        StackoneGetConnectorMeta.Async operation = new StackoneGetConnectorMeta.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler(), _headers);
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }
}

