/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AssignmentResultValue {
    public static final AssignmentResultValue PASS = new AssignmentResultValue("Pass");
    public static final AssignmentResultValue FAIL = new AssignmentResultValue("Fail");
    public static final AssignmentResultValue UNMAPPED_VALUE = new AssignmentResultValue("unmapped_value");
    private static final Map<String, AssignmentResultValue> values = AssignmentResultValue.createValuesMap();
    private static final Map<String, AssignmentResultValueEnum> enums = AssignmentResultValue.createEnumsMap();
    private final String value;

    private AssignmentResultValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static AssignmentResultValue of(String value) {
        Class<AssignmentResultValue> clazz = AssignmentResultValue.class;
        synchronized (AssignmentResultValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new AssignmentResultValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<AssignmentResultValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AssignmentResultValue other = (AssignmentResultValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "AssignmentResultValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AssignmentResultValue[] values() {
        Class<AssignmentResultValue> clazz = AssignmentResultValue.class;
        synchronized (AssignmentResultValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new AssignmentResultValue[0]);
        }
    }

    private static final Map<String, AssignmentResultValue> createValuesMap() {
        LinkedHashMap<String, AssignmentResultValue> map = new LinkedHashMap<String, AssignmentResultValue>();
        map.put("Pass", PASS);
        map.put("Fail", FAIL);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, AssignmentResultValueEnum> createEnumsMap() {
        HashMap<String, AssignmentResultValueEnum> map = new HashMap<String, AssignmentResultValueEnum>();
        map.put("Pass", AssignmentResultValueEnum.PASS);
        map.put("Fail", AssignmentResultValueEnum.FAIL);
        map.put("unmapped_value", AssignmentResultValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum AssignmentResultValueEnum {
        PASS("Pass"),
        FAIL("Fail"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private AssignmentResultValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

