/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class EmployeeMaritalStatusValue {
    public static final EmployeeMaritalStatusValue SINGLE = new EmployeeMaritalStatusValue("single");
    public static final EmployeeMaritalStatusValue MARRIED = new EmployeeMaritalStatusValue("married");
    public static final EmployeeMaritalStatusValue COMMON_LAW = new EmployeeMaritalStatusValue("common_law");
    public static final EmployeeMaritalStatusValue DIVORCED = new EmployeeMaritalStatusValue("divorced");
    public static final EmployeeMaritalStatusValue WIDOWED = new EmployeeMaritalStatusValue("widowed");
    public static final EmployeeMaritalStatusValue DOMESTIC_PARTNERSHIP = new EmployeeMaritalStatusValue("domestic_partnership");
    public static final EmployeeMaritalStatusValue SEPARATED = new EmployeeMaritalStatusValue("separated");
    public static final EmployeeMaritalStatusValue OTHER = new EmployeeMaritalStatusValue("other");
    public static final EmployeeMaritalStatusValue NOT_DISCLOSED = new EmployeeMaritalStatusValue("not_disclosed");
    public static final EmployeeMaritalStatusValue UNMAPPED_VALUE = new EmployeeMaritalStatusValue("unmapped_value");
    private static final Map<String, EmployeeMaritalStatusValue> values = EmployeeMaritalStatusValue.createValuesMap();
    private static final Map<String, EmployeeMaritalStatusValueEnum> enums = EmployeeMaritalStatusValue.createEnumsMap();
    private final String value;

    private EmployeeMaritalStatusValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static EmployeeMaritalStatusValue of(String value) {
        Class<EmployeeMaritalStatusValue> clazz = EmployeeMaritalStatusValue.class;
        synchronized (EmployeeMaritalStatusValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new EmployeeMaritalStatusValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<EmployeeMaritalStatusValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EmployeeMaritalStatusValue other = (EmployeeMaritalStatusValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "EmployeeMaritalStatusValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EmployeeMaritalStatusValue[] values() {
        Class<EmployeeMaritalStatusValue> clazz = EmployeeMaritalStatusValue.class;
        synchronized (EmployeeMaritalStatusValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new EmployeeMaritalStatusValue[0]);
        }
    }

    private static final Map<String, EmployeeMaritalStatusValue> createValuesMap() {
        LinkedHashMap<String, EmployeeMaritalStatusValue> map = new LinkedHashMap<String, EmployeeMaritalStatusValue>();
        map.put("single", SINGLE);
        map.put("married", MARRIED);
        map.put("common_law", COMMON_LAW);
        map.put("divorced", DIVORCED);
        map.put("widowed", WIDOWED);
        map.put("domestic_partnership", DOMESTIC_PARTNERSHIP);
        map.put("separated", SEPARATED);
        map.put("other", OTHER);
        map.put("not_disclosed", NOT_DISCLOSED);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, EmployeeMaritalStatusValueEnum> createEnumsMap() {
        HashMap<String, EmployeeMaritalStatusValueEnum> map = new HashMap<String, EmployeeMaritalStatusValueEnum>();
        map.put("single", EmployeeMaritalStatusValueEnum.SINGLE);
        map.put("married", EmployeeMaritalStatusValueEnum.MARRIED);
        map.put("common_law", EmployeeMaritalStatusValueEnum.COMMON_LAW);
        map.put("divorced", EmployeeMaritalStatusValueEnum.DIVORCED);
        map.put("widowed", EmployeeMaritalStatusValueEnum.WIDOWED);
        map.put("domestic_partnership", EmployeeMaritalStatusValueEnum.DOMESTIC_PARTNERSHIP);
        map.put("separated", EmployeeMaritalStatusValueEnum.SEPARATED);
        map.put("other", EmployeeMaritalStatusValueEnum.OTHER);
        map.put("not_disclosed", EmployeeMaritalStatusValueEnum.NOT_DISCLOSED);
        map.put("unmapped_value", EmployeeMaritalStatusValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum EmployeeMaritalStatusValueEnum {
        SINGLE("single"),
        MARRIED("married"),
        COMMON_LAW("common_law"),
        DIVORCED("divorced"),
        WIDOWED("widowed"),
        DOMESTIC_PARTNERSHIP("domestic_partnership"),
        SEPARATED("separated"),
        OTHER("other"),
        NOT_DISCLOSED("not_disclosed"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private EmployeeMaritalStatusValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

