/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class OfferValue {
    public static final OfferValue PENDING = new OfferValue("pending");
    public static final OfferValue RETRACTED = new OfferValue("retracted");
    public static final OfferValue ACCEPTED = new OfferValue("accepted");
    public static final OfferValue REJECTED = new OfferValue("rejected");
    public static final OfferValue CREATED = new OfferValue("created");
    public static final OfferValue APPROVED = new OfferValue("approved");
    public static final OfferValue NOT_APPROVED = new OfferValue("not_approved");
    public static final OfferValue UNMAPPED_VALUE = new OfferValue("unmapped_value");
    private static final Map<String, OfferValue> values = OfferValue.createValuesMap();
    private static final Map<String, OfferValueEnum> enums = OfferValue.createEnumsMap();
    private final String value;

    private OfferValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonCreator
    public static OfferValue of(String value) {
        Class<OfferValue> clazz = OfferValue.class;
        synchronized (OfferValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new OfferValue((String)v));
        }
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Optional<OfferValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OfferValue other = (OfferValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "OfferValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OfferValue[] values() {
        Class<OfferValue> clazz = OfferValue.class;
        synchronized (OfferValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new OfferValue[0]);
        }
    }

    private static final Map<String, OfferValue> createValuesMap() {
        LinkedHashMap<String, OfferValue> map = new LinkedHashMap<String, OfferValue>();
        map.put("pending", PENDING);
        map.put("retracted", RETRACTED);
        map.put("accepted", ACCEPTED);
        map.put("rejected", REJECTED);
        map.put("created", CREATED);
        map.put("approved", APPROVED);
        map.put("not_approved", NOT_APPROVED);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, OfferValueEnum> createEnumsMap() {
        HashMap<String, OfferValueEnum> map = new HashMap<String, OfferValueEnum>();
        map.put("pending", OfferValueEnum.PENDING);
        map.put("retracted", OfferValueEnum.RETRACTED);
        map.put("accepted", OfferValueEnum.ACCEPTED);
        map.put("rejected", OfferValueEnum.REJECTED);
        map.put("created", OfferValueEnum.CREATED);
        map.put("approved", OfferValueEnum.APPROVED);
        map.put("not_approved", OfferValueEnum.NOT_APPROVED);
        map.put("unmapped_value", OfferValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum OfferValueEnum {
        PENDING("pending"),
        RETRACTED("retracted"),
        ACCEPTED("accepted"),
        REJECTED("rejected"),
        CREATED("created"),
        APPROVED("approved"),
        NOT_APPROVED("not_approved"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private OfferValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

