/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.AccountingJournalBatchCreateRequestDto;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class AccountingBatchCreateCompanyJournalsRequest {
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=x-account-id")
    private String xAccountId;
    @SpeakeasyMetadata(value="pathParam:style=simple,explode=false,name=id")
    private String id;
    @SpeakeasyMetadata(value="header:style=simple,explode=false,name=Prefer")
    private Optional<String> prefer;
    @SpeakeasyMetadata(value="request:mediaType=application/json")
    private AccountingJournalBatchCreateRequestDto accountingJournalBatchCreateRequestDto;

    @JsonCreator
    public AccountingBatchCreateCompanyJournalsRequest(String xAccountId, String id, Optional<String> prefer, AccountingJournalBatchCreateRequestDto accountingJournalBatchCreateRequestDto) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(prefer, "prefer");
        Utils.checkNotNull(accountingJournalBatchCreateRequestDto, "accountingJournalBatchCreateRequestDto");
        this.xAccountId = xAccountId;
        this.id = id;
        this.prefer = prefer;
        this.accountingJournalBatchCreateRequestDto = accountingJournalBatchCreateRequestDto;
    }

    public AccountingBatchCreateCompanyJournalsRequest(String xAccountId, String id, AccountingJournalBatchCreateRequestDto accountingJournalBatchCreateRequestDto) {
        this(xAccountId, id, Optional.empty(), accountingJournalBatchCreateRequestDto);
    }

    @JsonIgnore
    public String xAccountId() {
        return this.xAccountId;
    }

    @JsonIgnore
    public String id() {
        return this.id;
    }

    @JsonIgnore
    public Optional<String> prefer() {
        return this.prefer;
    }

    @JsonIgnore
    public AccountingJournalBatchCreateRequestDto accountingJournalBatchCreateRequestDto() {
        return this.accountingJournalBatchCreateRequestDto;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AccountingBatchCreateCompanyJournalsRequest withXAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public AccountingBatchCreateCompanyJournalsRequest withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public AccountingBatchCreateCompanyJournalsRequest withPrefer(String prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = Optional.ofNullable(prefer);
        return this;
    }

    public AccountingBatchCreateCompanyJournalsRequest withPrefer(Optional<String> prefer) {
        Utils.checkNotNull(prefer, "prefer");
        this.prefer = prefer;
        return this;
    }

    public AccountingBatchCreateCompanyJournalsRequest withAccountingJournalBatchCreateRequestDto(AccountingJournalBatchCreateRequestDto accountingJournalBatchCreateRequestDto) {
        Utils.checkNotNull(accountingJournalBatchCreateRequestDto, "accountingJournalBatchCreateRequestDto");
        this.accountingJournalBatchCreateRequestDto = accountingJournalBatchCreateRequestDto;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountingBatchCreateCompanyJournalsRequest other = (AccountingBatchCreateCompanyJournalsRequest)o;
        return Utils.enhancedDeepEquals(this.xAccountId, other.xAccountId) && Utils.enhancedDeepEquals(this.id, other.id) && Utils.enhancedDeepEquals(this.prefer, other.prefer) && Utils.enhancedDeepEquals(this.accountingJournalBatchCreateRequestDto, other.accountingJournalBatchCreateRequestDto);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.xAccountId, this.id, this.prefer, this.accountingJournalBatchCreateRequestDto);
    }

    public String toString() {
        return Utils.toString(AccountingBatchCreateCompanyJournalsRequest.class, "xAccountId", this.xAccountId, "id", this.id, "prefer", this.prefer, "accountingJournalBatchCreateRequestDto", this.accountingJournalBatchCreateRequestDto);
    }

    public static final class Builder {
        private String xAccountId;
        private String id;
        private Optional<String> prefer = Optional.empty();
        private AccountingJournalBatchCreateRequestDto accountingJournalBatchCreateRequestDto;

        private Builder() {
        }

        public Builder xAccountId(String xAccountId) {
            Utils.checkNotNull(xAccountId, "xAccountId");
            this.xAccountId = xAccountId;
            return this;
        }

        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        public Builder prefer(String prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = Optional.ofNullable(prefer);
            return this;
        }

        public Builder prefer(Optional<String> prefer) {
            Utils.checkNotNull(prefer, "prefer");
            this.prefer = prefer;
            return this;
        }

        public Builder accountingJournalBatchCreateRequestDto(AccountingJournalBatchCreateRequestDto accountingJournalBatchCreateRequestDto) {
            Utils.checkNotNull(accountingJournalBatchCreateRequestDto, "accountingJournalBatchCreateRequestDto");
            this.accountingJournalBatchCreateRequestDto = accountingJournalBatchCreateRequestDto;
            return this;
        }

        public AccountingBatchCreateCompanyJournalsRequest build() {
            return new AccountingBatchCreateCompanyJournalsRequest(this.xAccountId, this.id, this.prefer, this.accountingJournalBatchCreateRequestDto);
        }
    }
}

