/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations.async;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.CreateAssessmentOrderResult;
import com.stackone.stackone_client_java.utils.AsyncResponse;
import com.stackone.stackone_client_java.utils.Blob;
import com.stackone.stackone_client_java.utils.Utils;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AtsOrderAssessmentsRequestResponse
implements AsyncResponse {
    private String contentType;
    private int statusCode;
    private HttpResponse<Blob> rawResponse;
    private Optional<? extends CreateAssessmentOrderResult> createAssessmentOrderResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public AtsOrderAssessmentsRequestResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Optional<? extends CreateAssessmentOrderResult> createAssessmentOrderResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(createAssessmentOrderResult, "createAssessmentOrderResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.createAssessmentOrderResult = createAssessmentOrderResult;
        this.headers = headers;
    }

    public AtsOrderAssessmentsRequestResponse(String contentType, int statusCode, HttpResponse<Blob> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<Blob> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<CreateAssessmentOrderResult> createAssessmentOrderResult() {
        return this.createAssessmentOrderResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AtsOrderAssessmentsRequestResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public AtsOrderAssessmentsRequestResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public AtsOrderAssessmentsRequestResponse withRawResponse(HttpResponse<Blob> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public AtsOrderAssessmentsRequestResponse withCreateAssessmentOrderResult(CreateAssessmentOrderResult createAssessmentOrderResult) {
        Utils.checkNotNull(createAssessmentOrderResult, "createAssessmentOrderResult");
        this.createAssessmentOrderResult = Optional.ofNullable(createAssessmentOrderResult);
        return this;
    }

    public AtsOrderAssessmentsRequestResponse withCreateAssessmentOrderResult(Optional<? extends CreateAssessmentOrderResult> createAssessmentOrderResult) {
        Utils.checkNotNull(createAssessmentOrderResult, "createAssessmentOrderResult");
        this.createAssessmentOrderResult = createAssessmentOrderResult;
        return this;
    }

    public AtsOrderAssessmentsRequestResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtsOrderAssessmentsRequestResponse other = (AtsOrderAssessmentsRequestResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.createAssessmentOrderResult, other.createAssessmentOrderResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.createAssessmentOrderResult, this.headers);
    }

    public String toString() {
        return Utils.toString(AtsOrderAssessmentsRequestResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "createAssessmentOrderResult", this.createAssessmentOrderResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<Blob> rawResponse;
        private Optional<? extends CreateAssessmentOrderResult> createAssessmentOrderResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<Blob> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder createAssessmentOrderResult(CreateAssessmentOrderResult createAssessmentOrderResult) {
            Utils.checkNotNull(createAssessmentOrderResult, "createAssessmentOrderResult");
            this.createAssessmentOrderResult = Optional.ofNullable(createAssessmentOrderResult);
            return this;
        }

        public Builder createAssessmentOrderResult(Optional<? extends CreateAssessmentOrderResult> createAssessmentOrderResult) {
            Utils.checkNotNull(createAssessmentOrderResult, "createAssessmentOrderResult");
            this.createAssessmentOrderResult = createAssessmentOrderResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public AtsOrderAssessmentsRequestResponse build() {
            return new AtsOrderAssessmentsRequestResponse(this.contentType, this.statusCode, this.rawResponse, this.createAssessmentOrderResult, this.headers);
        }
    }
}

