/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class EmploymentCostCenterValue {
    public static final EmploymentCostCenterValue WORKSPACE = new EmploymentCostCenterValue("workspace");
    public static final EmploymentCostCenterValue TEAM = new EmploymentCostCenterValue("team");
    public static final EmploymentCostCenterValue DEPARTMENT = new EmploymentCostCenterValue("department");
    public static final EmploymentCostCenterValue GROUP = new EmploymentCostCenterValue("group");
    public static final EmploymentCostCenterValue ORGANIZATION = new EmploymentCostCenterValue("organization");
    public static final EmploymentCostCenterValue UNMAPPED_VALUE = new EmploymentCostCenterValue("unmapped_value");
    public static final EmploymentCostCenterValue COST_CENTER = new EmploymentCostCenterValue("cost_center");
    private static final Map<String, EmploymentCostCenterValue> values = EmploymentCostCenterValue.createValuesMap();
    private static final Map<String, EmploymentCostCenterValueEnum> enums = EmploymentCostCenterValue.createEnumsMap();
    private final String value;

    private EmploymentCostCenterValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EmploymentCostCenterValue of(String value) {
        Class<EmploymentCostCenterValue> clazz = EmploymentCostCenterValue.class;
        synchronized (EmploymentCostCenterValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new EmploymentCostCenterValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<EmploymentCostCenterValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EmploymentCostCenterValue other = (EmploymentCostCenterValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "EmploymentCostCenterValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EmploymentCostCenterValue[] values() {
        Class<EmploymentCostCenterValue> clazz = EmploymentCostCenterValue.class;
        synchronized (EmploymentCostCenterValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new EmploymentCostCenterValue[0]);
        }
    }

    private static final Map<String, EmploymentCostCenterValue> createValuesMap() {
        LinkedHashMap<String, EmploymentCostCenterValue> map = new LinkedHashMap<String, EmploymentCostCenterValue>();
        map.put("workspace", WORKSPACE);
        map.put("team", TEAM);
        map.put("department", DEPARTMENT);
        map.put("group", GROUP);
        map.put("organization", ORGANIZATION);
        map.put("unmapped_value", UNMAPPED_VALUE);
        map.put("cost_center", COST_CENTER);
        return map;
    }

    private static final Map<String, EmploymentCostCenterValueEnum> createEnumsMap() {
        HashMap<String, EmploymentCostCenterValueEnum> map = new HashMap<String, EmploymentCostCenterValueEnum>();
        map.put("workspace", EmploymentCostCenterValueEnum.WORKSPACE);
        map.put("team", EmploymentCostCenterValueEnum.TEAM);
        map.put("department", EmploymentCostCenterValueEnum.DEPARTMENT);
        map.put("group", EmploymentCostCenterValueEnum.GROUP);
        map.put("organization", EmploymentCostCenterValueEnum.ORGANIZATION);
        map.put("unmapped_value", EmploymentCostCenterValueEnum.UNMAPPED_VALUE);
        map.put("cost_center", EmploymentCostCenterValueEnum.COST_CENTER);
        return map;
    }

    public static enum EmploymentCostCenterValueEnum {
        WORKSPACE("workspace"),
        TEAM("team"),
        DEPARTMENT("department"),
        GROUP("group"),
        ORGANIZATION("organization"),
        UNMAPPED_VALUE("unmapped_value"),
        COST_CENTER("cost_center");

        private final String value;

        private EmploymentCostCenterValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<EmploymentCostCenterValue> {
        protected _Deserializer() {
            super(EmploymentCostCenterValue.class);
        }

        public EmploymentCostCenterValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return EmploymentCostCenterValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<EmploymentCostCenterValue> {
        protected _Serializer() {
            super(EmploymentCostCenterValue.class);
        }

        public void serialize(EmploymentCostCenterValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

