/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.models.operations.SDKMethodInterfaces;
import com.stackone.stackone_client_java.models.operations.StackoneGetConnectorMetaResponse;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;
import org.openapitools.jackson.nullable.JsonNullable;

public class StackoneGetConnectorMetaRequestBuilder {
    private String provider;
    private JsonNullable<String> include = JsonNullable.undefined();
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKMethodInterfaces.MethodCallStackoneGetConnectorMeta sdk;

    public StackoneGetConnectorMetaRequestBuilder(SDKMethodInterfaces.MethodCallStackoneGetConnectorMeta sdk) {
        this.sdk = sdk;
    }

    public StackoneGetConnectorMetaRequestBuilder provider(String provider) {
        Utils.checkNotNull(provider, "provider");
        this.provider = provider;
        return this;
    }

    public StackoneGetConnectorMetaRequestBuilder include(String include) {
        Utils.checkNotNull(include, "include");
        this.include = JsonNullable.of((Object)include);
        return this;
    }

    public StackoneGetConnectorMetaRequestBuilder include(JsonNullable<String> include) {
        Utils.checkNotNull(include, "include");
        this.include = include;
        return this;
    }

    public StackoneGetConnectorMetaRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public StackoneGetConnectorMetaRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public StackoneGetConnectorMetaResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        return this.sdk.getConnectorMeta(this.provider, this.include, options);
    }
}

