/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.stackone.stackone_client_java.utils.BigDecimalString;
import com.stackone.stackone_client_java.utils.BigIntegerString;
import com.stackone.stackone_client_java.utils.JSON;
import com.stackone.stackone_client_java.utils.TypedObject;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class OneOfDeserializer<T>
extends StdDeserializer<T> {
    private static final long serialVersionUID = -1L;
    private final transient List<Utils.TypeReferenceWithShape> typeReferences;
    private final Class<T> cls;
    private final boolean strict;
    private final ObjectMapper mapper;
    private static final Set<String> NUMERIC_CLASSES = Set.of(Integer.class.getCanonicalName(), Long.class.getCanonicalName(), BigInteger.class.getCanonicalName(), Float.class.getCanonicalName(), Double.class.getCanonicalName(), BigDecimal.class.getCanonicalName());
    private static final Set<String> DECIMAL_CLASSES = Set.of(Float.class.getCanonicalName(), Double.class.getCanonicalName(), BigDecimal.class.getCanonicalName());
    private static final Set<String> INTEGER_CLASSES = Set.of(Integer.class.getCanonicalName(), Long.class.getCanonicalName(), BigInteger.class.getCanonicalName());
    private static final Set<String> DATE_TIME_CLASSES = Set.of(OffsetDateTime.class.getCanonicalName(), LocalDate.class.getCanonicalName());

    protected OneOfDeserializer(Class<T> cls, boolean strict, Utils.TypeReferenceWithShape ... typeReferences) {
        super(cls);
        this.typeReferences = Arrays.asList(typeReferences);
        this.cls = cls;
        this.strict = strict;
        this.mapper = JSON.getMapper();
    }

    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        return OneOfDeserializer.deserializeOneOf(this.mapper, p, ctxt, this.typeReferences, this.cls, this.strict);
    }

    private static <T> T deserializeOneOf(ObjectMapper mapper, JsonParser p, DeserializationContext ctxt, List<Utils.TypeReferenceWithShape> typeReferences, Class<T> cls, boolean strict) throws IOException {
        TreeNode tree = p.getCodec().readTree(p);
        String json = mapper.writeValueAsString((Object)tree);
        return OneOfDeserializer.deserializeOneOf(mapper, json, typeReferences, cls, ctxt, strict);
    }

    private static <T> T deserializeOneOf(ObjectMapper mapper, String json, List<Utils.TypeReferenceWithShape> typeReferences, Class<T> cls, DeserializationContext ctxt, boolean strict) throws JsonProcessingException {
        List<Match<T>> matches = new ArrayList<Match<T>>();
        for (Utils.TypeReferenceWithShape c : typeReferences) {
            try {
                JavaType jt = Utils.convertToShape(mapper.getTypeFactory(), c.typeReference(), c.shape());
                if (!OneOfDeserializer.matchPossible(jt, json)) continue;
                Object o = mapper.readValue(json, jt);
                o = Utils.convertToShapeInverse(o, c.shape(), jt);
                TypedObject typed = TypedObject.of(o, c.shape(), c.typeReference());
                T v = OneOfDeserializer.newInstance(cls, typed);
                matches.add(new Match<T>(c, v));
            }
            catch (DatabindException databindException) {}
        }
        if ((matches = OneOfDeserializer.applyMatchPreferences(matches, json)).size() == 1) {
            return matches.get((int)0).value;
        }
        if (matches.size() > 1) {
            if (strict) {
                throw JsonMappingException.from((DeserializationContext)ctxt, (String)("json matched more than one of the possible type references, matches are: " + OneOfDeserializer.typeNames(matches) + " - json=\n" + json));
            }
            return matches.get((int)0).value;
        }
        throw JsonMappingException.from((DeserializationContext)ctxt, (String)("json did not match any of the possible type references: " + OneOfDeserializer.typeReferenceNames(typeReferences) + ", json=\n" + json));
    }

    public static boolean matchPossible(JavaType type, String json) {
        if (OneOfDeserializer.typeIs(type, String.class) || OneOfDeserializer.typeIs(type, BigIntegerString.class) || OneOfDeserializer.typeIs(type, BigDecimalString.class)) {
            return OneOfDeserializer.isDoubleQuoted(json);
        }
        if (OneOfDeserializer.typeIs(type, Boolean.class)) {
            return json.equals("true") || json.equals("false");
        }
        if (NUMERIC_CLASSES.contains(type.getTypeName())) {
            return !json.contains("\"");
        }
        if (OneOfDeserializer.typeIs(type, OffsetDateTime.class) || OneOfDeserializer.typeIs(type, LocalDate.class)) {
            return OneOfDeserializer.isDoubleQuoted(json) && !OneOfDeserializer.isNumeric(json.substring(1, json.length() - 1));
        }
        return true;
    }

    private static boolean isDoubleQuoted(String s) {
        return s.length() >= 2 && s.startsWith("\"") && s.endsWith("\"");
    }

    public static <T> List<Match<T>> applyMatchPreferences(List<Match<T>> matches, String json) {
        if (matches.size() <= 1) {
            return matches;
        }
        if (OneOfDeserializer.allNumeric(matches)) {
            List<Match<T>> decimalMatches = OneOfDeserializer.decimalMatches(matches);
            List<Match<T>> integerMatches = OneOfDeserializer.integerMatches(matches);
            if (!decimalMatches.isEmpty() && !integerMatches.isEmpty()) {
                if (json.contains("e") || json.contains(".")) {
                    return decimalMatches;
                }
                return integerMatches;
            }
            if (!decimalMatches.isEmpty()) {
                return decimalMatches;
            }
            return integerMatches;
        }
        if (OneOfDeserializer.allDateTime(matches)) {
            if (json.contains("T")) {
                return OneOfDeserializer.filter(matches, OffsetDateTime.class);
            }
            return OneOfDeserializer.filter(matches, LocalDate.class);
        }
        return matches;
    }

    private static <T> List<Match<T>> filter(List<Match<T>> matches, Class<?> filterByClass) {
        return matches.stream().filter(x -> x.typeReference.typeReference().getType().getTypeName().equals(filterByClass.getCanonicalName())).collect(Collectors.toList());
    }

    private static <T> boolean allDateTime(List<Match<T>> matches) {
        return matches.stream().allMatch(x -> DATE_TIME_CLASSES.contains(x.typeReference.typeReference().getType().getTypeName()));
    }

    private static <T> boolean allNumeric(List<Match<T>> matches) {
        return matches.stream().allMatch(x -> NUMERIC_CLASSES.contains(x.typeReference.typeReference().getType().getTypeName()));
    }

    private static <T> List<Match<T>> decimalMatches(List<Match<T>> matches) {
        return matches.stream().filter(x -> DECIMAL_CLASSES.contains(x.typeReference.typeReference().getType().getTypeName())).collect(Collectors.toList());
    }

    private static <T> List<Match<T>> integerMatches(List<Match<T>> matches) {
        return matches.stream().filter(x -> INTEGER_CLASSES.contains(x.typeReference.typeReference().getType().getTypeName())).collect(Collectors.toList());
    }

    private static boolean isNumeric(String s) {
        try {
            Double.parseDouble(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean typeIs(JavaType type, Class<?> cls) {
        return type.getRawClass().equals(cls);
    }

    private static <T> String typeNames(List<Match<T>> matches) {
        return "[" + matches.stream().map(x -> x.typeReference.typeReference().getType().getTypeName()).collect(Collectors.joining(", ")) + "]";
    }

    private static String typeReferenceNames(List<Utils.TypeReferenceWithShape> list) {
        return "[" + list.stream().map(x -> x.typeReference().getType().getTypeName()).collect(Collectors.joining(", ")) + "]";
    }

    private static <T> T newInstance(Class<T> cls, Object parameter) {
        try {
            Constructor<T> con = cls.getDeclaredConstructor(TypedObject.class);
            con.setAccessible(true);
            return con.newInstance(parameter);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static final class Match<T> {
        final Utils.TypeReferenceWithShape typeReference;
        final T value;

        Match(Utils.TypeReferenceWithShape typeReference, T value) {
            this.typeReference = typeReference;
            this.value = value;
        }
    }
}

