/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java;

import static com.stackone.stackone_client_java.operations.Operations.RequestOperation;

import com.stackone.stackone_client_java.models.components.ProxyRequestBody;
import com.stackone.stackone_client_java.models.operations.StackoneProxyRequestRequest;
import com.stackone.stackone_client_java.models.operations.StackoneProxyRequestRequestBuilder;
import com.stackone.stackone_client_java.models.operations.StackoneProxyRequestResponse;
import com.stackone.stackone_client_java.operations.StackoneProxyRequestOperation;
import com.stackone.stackone_client_java.utils.Options;
import java.lang.Exception;
import java.lang.String;
import java.util.List;
import java.util.Optional;

/**
 * Routing API requests through StackOne directly to the underlying provider.
 */
public class Proxy {
    private final SDKConfiguration sdkConfiguration;

    Proxy(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    /**
     * Proxy Request
     * 
     * @return The call builder
     */
    public StackoneProxyRequestRequestBuilder proxyRequest() {
        return new StackoneProxyRequestRequestBuilder(sdkConfiguration);
    }

    /**
     * Proxy Request
     * 
     * @param xAccountId The account identifier
     * @param proxyRequestBody 
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public StackoneProxyRequestResponse proxyRequest(
            String xAccountId,
            ProxyRequestBody proxyRequestBody) throws Exception {
        return proxyRequest(xAccountId, proxyRequestBody, Optional.empty());
    }

    /**
     * Proxy Request
     * 
     * @param xAccountId The account identifier
     * @param proxyRequestBody 
     * @param options additional options
     * @return The response from the API call
     * @throws Exception if the API call fails
     */
    public StackoneProxyRequestResponse proxyRequest(
            String xAccountId,
            ProxyRequestBody proxyRequestBody,
            Optional<Options> options) throws Exception {
        StackoneProxyRequestRequest request =
            StackoneProxyRequestRequest
                .builder()
                .xAccountId(xAccountId)
                .proxyRequestBody(proxyRequestBody)
                .build();
        RequestOperation<StackoneProxyRequestRequest, StackoneProxyRequestResponse> operation
              = new StackoneProxyRequestOperation(
                 sdkConfiguration,
                 options);
        return operation.handleResponse(operation.doRequest(request));
    }

}
