/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;

public class AtsCreateApplicationRequestDto {

    /**
     * Value to pass through to the provider
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("passthrough")
    private JsonNullable<? extends Map<String, Object>> passthrough;

    /**
     * Unique identifier of the job
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("job_id")
    private JsonNullable<String> jobId;

    /**
     * Unique identifier of the job posting that is associated with application
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("job_posting_id")
    private JsonNullable<String> jobPostingId;

    /**
     * Unique identifier of the location
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("location_id")
    private JsonNullable<String> locationId;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("application_status")
    private JsonNullable<? extends AtsCreateApplicationRequestDtoApplicationStatus> applicationStatus;

    /**
     * Questionnaires associated with the application
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("questionnaires")
    private JsonNullable<? extends List<CreateQuestionnaire>> questionnaires;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source")
    private JsonNullable<? extends AtsCreateApplicationRequestDtoSource> source;

    /**
     * Unique identifier of the candidate. Provide this OR candidate, but not both.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("candidate_id")
    private JsonNullable<String> candidateId;

    /**
     * Candidate Properties. Provide this OR candidate_id, but not both. Providing this attempts to create a new candidate with the application.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("candidate")
    private JsonNullable<? extends AtsCreateApplicationRequestDtoCandidate> candidate;

    /**
     * Document Properties. Providing this attempts to upload files with the application.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("documents")
    private JsonNullable<? extends List<UnifiedUploadRequestDto>> documents;

    @JsonCreator
    public AtsCreateApplicationRequestDto(
            @JsonProperty("passthrough") JsonNullable<? extends Map<String, Object>> passthrough,
            @JsonProperty("job_id") JsonNullable<String> jobId,
            @JsonProperty("job_posting_id") JsonNullable<String> jobPostingId,
            @JsonProperty("location_id") JsonNullable<String> locationId,
            @JsonProperty("application_status") JsonNullable<? extends AtsCreateApplicationRequestDtoApplicationStatus> applicationStatus,
            @JsonProperty("questionnaires") JsonNullable<? extends List<CreateQuestionnaire>> questionnaires,
            @JsonProperty("source") JsonNullable<? extends AtsCreateApplicationRequestDtoSource> source,
            @JsonProperty("candidate_id") JsonNullable<String> candidateId,
            @JsonProperty("candidate") JsonNullable<? extends AtsCreateApplicationRequestDtoCandidate> candidate,
            @JsonProperty("documents") JsonNullable<? extends List<UnifiedUploadRequestDto>> documents) {
        Utils.checkNotNull(passthrough, "passthrough");
        Utils.checkNotNull(jobId, "jobId");
        Utils.checkNotNull(jobPostingId, "jobPostingId");
        Utils.checkNotNull(locationId, "locationId");
        Utils.checkNotNull(applicationStatus, "applicationStatus");
        Utils.checkNotNull(questionnaires, "questionnaires");
        Utils.checkNotNull(source, "source");
        Utils.checkNotNull(candidateId, "candidateId");
        Utils.checkNotNull(candidate, "candidate");
        Utils.checkNotNull(documents, "documents");
        this.passthrough = passthrough;
        this.jobId = jobId;
        this.jobPostingId = jobPostingId;
        this.locationId = locationId;
        this.applicationStatus = applicationStatus;
        this.questionnaires = questionnaires;
        this.source = source;
        this.candidateId = candidateId;
        this.candidate = candidate;
        this.documents = documents;
    }
    
    public AtsCreateApplicationRequestDto() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Value to pass through to the provider
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> passthrough() {
        return (JsonNullable<Map<String, Object>>) passthrough;
    }

    /**
     * Unique identifier of the job
     */
    @JsonIgnore
    public JsonNullable<String> jobId() {
        return jobId;
    }

    /**
     * Unique identifier of the job posting that is associated with application
     */
    @JsonIgnore
    public JsonNullable<String> jobPostingId() {
        return jobPostingId;
    }

    /**
     * Unique identifier of the location
     */
    @JsonIgnore
    public JsonNullable<String> locationId() {
        return locationId;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AtsCreateApplicationRequestDtoApplicationStatus> applicationStatus() {
        return (JsonNullable<AtsCreateApplicationRequestDtoApplicationStatus>) applicationStatus;
    }

    /**
     * Questionnaires associated with the application
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<CreateQuestionnaire>> questionnaires() {
        return (JsonNullable<List<CreateQuestionnaire>>) questionnaires;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AtsCreateApplicationRequestDtoSource> source() {
        return (JsonNullable<AtsCreateApplicationRequestDtoSource>) source;
    }

    /**
     * Unique identifier of the candidate. Provide this OR candidate, but not both.
     */
    @JsonIgnore
    public JsonNullable<String> candidateId() {
        return candidateId;
    }

    /**
     * Candidate Properties. Provide this OR candidate_id, but not both. Providing this attempts to create a new candidate with the application.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AtsCreateApplicationRequestDtoCandidate> candidate() {
        return (JsonNullable<AtsCreateApplicationRequestDtoCandidate>) candidate;
    }

    /**
     * Document Properties. Providing this attempts to upload files with the application.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<UnifiedUploadRequestDto>> documents() {
        return (JsonNullable<List<UnifiedUploadRequestDto>>) documents;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * Value to pass through to the provider
     */
    public AtsCreateApplicationRequestDto withPassthrough(Map<String, Object> passthrough) {
        Utils.checkNotNull(passthrough, "passthrough");
        this.passthrough = JsonNullable.of(passthrough);
        return this;
    }

    /**
     * Value to pass through to the provider
     */
    public AtsCreateApplicationRequestDto withPassthrough(JsonNullable<? extends Map<String, Object>> passthrough) {
        Utils.checkNotNull(passthrough, "passthrough");
        this.passthrough = passthrough;
        return this;
    }

    /**
     * Unique identifier of the job
     */
    public AtsCreateApplicationRequestDto withJobId(String jobId) {
        Utils.checkNotNull(jobId, "jobId");
        this.jobId = JsonNullable.of(jobId);
        return this;
    }

    /**
     * Unique identifier of the job
     */
    public AtsCreateApplicationRequestDto withJobId(JsonNullable<String> jobId) {
        Utils.checkNotNull(jobId, "jobId");
        this.jobId = jobId;
        return this;
    }

    /**
     * Unique identifier of the job posting that is associated with application
     */
    public AtsCreateApplicationRequestDto withJobPostingId(String jobPostingId) {
        Utils.checkNotNull(jobPostingId, "jobPostingId");
        this.jobPostingId = JsonNullable.of(jobPostingId);
        return this;
    }

    /**
     * Unique identifier of the job posting that is associated with application
     */
    public AtsCreateApplicationRequestDto withJobPostingId(JsonNullable<String> jobPostingId) {
        Utils.checkNotNull(jobPostingId, "jobPostingId");
        this.jobPostingId = jobPostingId;
        return this;
    }

    /**
     * Unique identifier of the location
     */
    public AtsCreateApplicationRequestDto withLocationId(String locationId) {
        Utils.checkNotNull(locationId, "locationId");
        this.locationId = JsonNullable.of(locationId);
        return this;
    }

    /**
     * Unique identifier of the location
     */
    public AtsCreateApplicationRequestDto withLocationId(JsonNullable<String> locationId) {
        Utils.checkNotNull(locationId, "locationId");
        this.locationId = locationId;
        return this;
    }

    public AtsCreateApplicationRequestDto withApplicationStatus(AtsCreateApplicationRequestDtoApplicationStatus applicationStatus) {
        Utils.checkNotNull(applicationStatus, "applicationStatus");
        this.applicationStatus = JsonNullable.of(applicationStatus);
        return this;
    }

    public AtsCreateApplicationRequestDto withApplicationStatus(JsonNullable<? extends AtsCreateApplicationRequestDtoApplicationStatus> applicationStatus) {
        Utils.checkNotNull(applicationStatus, "applicationStatus");
        this.applicationStatus = applicationStatus;
        return this;
    }

    /**
     * Questionnaires associated with the application
     */
    public AtsCreateApplicationRequestDto withQuestionnaires(List<CreateQuestionnaire> questionnaires) {
        Utils.checkNotNull(questionnaires, "questionnaires");
        this.questionnaires = JsonNullable.of(questionnaires);
        return this;
    }

    /**
     * Questionnaires associated with the application
     */
    public AtsCreateApplicationRequestDto withQuestionnaires(JsonNullable<? extends List<CreateQuestionnaire>> questionnaires) {
        Utils.checkNotNull(questionnaires, "questionnaires");
        this.questionnaires = questionnaires;
        return this;
    }

    public AtsCreateApplicationRequestDto withSource(AtsCreateApplicationRequestDtoSource source) {
        Utils.checkNotNull(source, "source");
        this.source = JsonNullable.of(source);
        return this;
    }

    public AtsCreateApplicationRequestDto withSource(JsonNullable<? extends AtsCreateApplicationRequestDtoSource> source) {
        Utils.checkNotNull(source, "source");
        this.source = source;
        return this;
    }

    /**
     * Unique identifier of the candidate. Provide this OR candidate, but not both.
     */
    public AtsCreateApplicationRequestDto withCandidateId(String candidateId) {
        Utils.checkNotNull(candidateId, "candidateId");
        this.candidateId = JsonNullable.of(candidateId);
        return this;
    }

    /**
     * Unique identifier of the candidate. Provide this OR candidate, but not both.
     */
    public AtsCreateApplicationRequestDto withCandidateId(JsonNullable<String> candidateId) {
        Utils.checkNotNull(candidateId, "candidateId");
        this.candidateId = candidateId;
        return this;
    }

    /**
     * Candidate Properties. Provide this OR candidate_id, but not both. Providing this attempts to create a new candidate with the application.
     */
    public AtsCreateApplicationRequestDto withCandidate(AtsCreateApplicationRequestDtoCandidate candidate) {
        Utils.checkNotNull(candidate, "candidate");
        this.candidate = JsonNullable.of(candidate);
        return this;
    }

    /**
     * Candidate Properties. Provide this OR candidate_id, but not both. Providing this attempts to create a new candidate with the application.
     */
    public AtsCreateApplicationRequestDto withCandidate(JsonNullable<? extends AtsCreateApplicationRequestDtoCandidate> candidate) {
        Utils.checkNotNull(candidate, "candidate");
        this.candidate = candidate;
        return this;
    }

    /**
     * Document Properties. Providing this attempts to upload files with the application.
     */
    public AtsCreateApplicationRequestDto withDocuments(List<UnifiedUploadRequestDto> documents) {
        Utils.checkNotNull(documents, "documents");
        this.documents = JsonNullable.of(documents);
        return this;
    }

    /**
     * Document Properties. Providing this attempts to upload files with the application.
     */
    public AtsCreateApplicationRequestDto withDocuments(JsonNullable<? extends List<UnifiedUploadRequestDto>> documents) {
        Utils.checkNotNull(documents, "documents");
        this.documents = documents;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        AtsCreateApplicationRequestDto other = (AtsCreateApplicationRequestDto) o;
        return 
            Utils.enhancedDeepEquals(this.passthrough, other.passthrough) &&
            Utils.enhancedDeepEquals(this.jobId, other.jobId) &&
            Utils.enhancedDeepEquals(this.jobPostingId, other.jobPostingId) &&
            Utils.enhancedDeepEquals(this.locationId, other.locationId) &&
            Utils.enhancedDeepEquals(this.applicationStatus, other.applicationStatus) &&
            Utils.enhancedDeepEquals(this.questionnaires, other.questionnaires) &&
            Utils.enhancedDeepEquals(this.source, other.source) &&
            Utils.enhancedDeepEquals(this.candidateId, other.candidateId) &&
            Utils.enhancedDeepEquals(this.candidate, other.candidate) &&
            Utils.enhancedDeepEquals(this.documents, other.documents);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            passthrough,
            jobId,
            jobPostingId,
            locationId,
            applicationStatus,
            questionnaires,
            source,
            candidateId,
            candidate,
            documents);
    }
    
    @Override
    public String toString() {
        return Utils.toString(AtsCreateApplicationRequestDto.class,
                "passthrough", passthrough,
                "jobId", jobId,
                "jobPostingId", jobPostingId,
                "locationId", locationId,
                "applicationStatus", applicationStatus,
                "questionnaires", questionnaires,
                "source", source,
                "candidateId", candidateId,
                "candidate", candidate,
                "documents", documents);
    }
    
    public final static class Builder {
 
        private JsonNullable<? extends Map<String, Object>> passthrough = JsonNullable.undefined();
 
        private JsonNullable<String> jobId = JsonNullable.undefined();
 
        private JsonNullable<String> jobPostingId = JsonNullable.undefined();
 
        private JsonNullable<String> locationId = JsonNullable.undefined();
 
        private JsonNullable<? extends AtsCreateApplicationRequestDtoApplicationStatus> applicationStatus = JsonNullable.undefined();
 
        private JsonNullable<? extends List<CreateQuestionnaire>> questionnaires = JsonNullable.undefined();
 
        private JsonNullable<? extends AtsCreateApplicationRequestDtoSource> source = JsonNullable.undefined();
 
        private JsonNullable<String> candidateId = JsonNullable.undefined();
 
        private JsonNullable<? extends AtsCreateApplicationRequestDtoCandidate> candidate = JsonNullable.undefined();
 
        private JsonNullable<? extends List<UnifiedUploadRequestDto>> documents = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Value to pass through to the provider
         */
        public Builder passthrough(Map<String, Object> passthrough) {
            Utils.checkNotNull(passthrough, "passthrough");
            this.passthrough = JsonNullable.of(passthrough);
            return this;
        }

        /**
         * Value to pass through to the provider
         */
        public Builder passthrough(JsonNullable<? extends Map<String, Object>> passthrough) {
            Utils.checkNotNull(passthrough, "passthrough");
            this.passthrough = passthrough;
            return this;
        }

        /**
         * Unique identifier of the job
         */
        public Builder jobId(String jobId) {
            Utils.checkNotNull(jobId, "jobId");
            this.jobId = JsonNullable.of(jobId);
            return this;
        }

        /**
         * Unique identifier of the job
         */
        public Builder jobId(JsonNullable<String> jobId) {
            Utils.checkNotNull(jobId, "jobId");
            this.jobId = jobId;
            return this;
        }

        /**
         * Unique identifier of the job posting that is associated with application
         */
        public Builder jobPostingId(String jobPostingId) {
            Utils.checkNotNull(jobPostingId, "jobPostingId");
            this.jobPostingId = JsonNullable.of(jobPostingId);
            return this;
        }

        /**
         * Unique identifier of the job posting that is associated with application
         */
        public Builder jobPostingId(JsonNullable<String> jobPostingId) {
            Utils.checkNotNull(jobPostingId, "jobPostingId");
            this.jobPostingId = jobPostingId;
            return this;
        }

        /**
         * Unique identifier of the location
         */
        public Builder locationId(String locationId) {
            Utils.checkNotNull(locationId, "locationId");
            this.locationId = JsonNullable.of(locationId);
            return this;
        }

        /**
         * Unique identifier of the location
         */
        public Builder locationId(JsonNullable<String> locationId) {
            Utils.checkNotNull(locationId, "locationId");
            this.locationId = locationId;
            return this;
        }

        public Builder applicationStatus(AtsCreateApplicationRequestDtoApplicationStatus applicationStatus) {
            Utils.checkNotNull(applicationStatus, "applicationStatus");
            this.applicationStatus = JsonNullable.of(applicationStatus);
            return this;
        }

        public Builder applicationStatus(JsonNullable<? extends AtsCreateApplicationRequestDtoApplicationStatus> applicationStatus) {
            Utils.checkNotNull(applicationStatus, "applicationStatus");
            this.applicationStatus = applicationStatus;
            return this;
        }

        /**
         * Questionnaires associated with the application
         */
        public Builder questionnaires(List<CreateQuestionnaire> questionnaires) {
            Utils.checkNotNull(questionnaires, "questionnaires");
            this.questionnaires = JsonNullable.of(questionnaires);
            return this;
        }

        /**
         * Questionnaires associated with the application
         */
        public Builder questionnaires(JsonNullable<? extends List<CreateQuestionnaire>> questionnaires) {
            Utils.checkNotNull(questionnaires, "questionnaires");
            this.questionnaires = questionnaires;
            return this;
        }

        public Builder source(AtsCreateApplicationRequestDtoSource source) {
            Utils.checkNotNull(source, "source");
            this.source = JsonNullable.of(source);
            return this;
        }

        public Builder source(JsonNullable<? extends AtsCreateApplicationRequestDtoSource> source) {
            Utils.checkNotNull(source, "source");
            this.source = source;
            return this;
        }

        /**
         * Unique identifier of the candidate. Provide this OR candidate, but not both.
         */
        public Builder candidateId(String candidateId) {
            Utils.checkNotNull(candidateId, "candidateId");
            this.candidateId = JsonNullable.of(candidateId);
            return this;
        }

        /**
         * Unique identifier of the candidate. Provide this OR candidate, but not both.
         */
        public Builder candidateId(JsonNullable<String> candidateId) {
            Utils.checkNotNull(candidateId, "candidateId");
            this.candidateId = candidateId;
            return this;
        }

        /**
         * Candidate Properties. Provide this OR candidate_id, but not both. Providing this attempts to create a new candidate with the application.
         */
        public Builder candidate(AtsCreateApplicationRequestDtoCandidate candidate) {
            Utils.checkNotNull(candidate, "candidate");
            this.candidate = JsonNullable.of(candidate);
            return this;
        }

        /**
         * Candidate Properties. Provide this OR candidate_id, but not both. Providing this attempts to create a new candidate with the application.
         */
        public Builder candidate(JsonNullable<? extends AtsCreateApplicationRequestDtoCandidate> candidate) {
            Utils.checkNotNull(candidate, "candidate");
            this.candidate = candidate;
            return this;
        }

        /**
         * Document Properties. Providing this attempts to upload files with the application.
         */
        public Builder documents(List<UnifiedUploadRequestDto> documents) {
            Utils.checkNotNull(documents, "documents");
            this.documents = JsonNullable.of(documents);
            return this;
        }

        /**
         * Document Properties. Providing this attempts to upload files with the application.
         */
        public Builder documents(JsonNullable<? extends List<UnifiedUploadRequestDto>> documents) {
            Utils.checkNotNull(documents, "documents");
            this.documents = documents;
            return this;
        }
        
        public AtsCreateApplicationRequestDto build() {
            return new AtsCreateApplicationRequestDto(
                passthrough,
                jobId,
                jobPostingId,
                locationId,
                applicationStatus,
                questionnaires,
                source,
                candidateId,
                candidate,
                documents);
        }
    }
}
