/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * AtsDocumentApiModelTypeValue
 * 
 * <p>The category of the file
 */
@JsonDeserialize(using = AtsDocumentApiModelTypeValue._Deserializer.class)
@JsonSerialize(using = AtsDocumentApiModelTypeValue._Serializer.class)
public class AtsDocumentApiModelTypeValue {

    public static final AtsDocumentApiModelTypeValue RESUME = new AtsDocumentApiModelTypeValue("resume");
    public static final AtsDocumentApiModelTypeValue AVATAR = new AtsDocumentApiModelTypeValue("avatar");
    public static final AtsDocumentApiModelTypeValue COVER_LETTER = new AtsDocumentApiModelTypeValue("cover_letter");
    public static final AtsDocumentApiModelTypeValue PROFILE_PICTURE = new AtsDocumentApiModelTypeValue("profile_picture");
    public static final AtsDocumentApiModelTypeValue POLICY = new AtsDocumentApiModelTypeValue("policy");
    public static final AtsDocumentApiModelTypeValue PASSPORT = new AtsDocumentApiModelTypeValue("passport");
    public static final AtsDocumentApiModelTypeValue ASSESSMENT = new AtsDocumentApiModelTypeValue("assessment");
    public static final AtsDocumentApiModelTypeValue INTERVIEW_ATTACHMENT = new AtsDocumentApiModelTypeValue("interview_attachment");
    public static final AtsDocumentApiModelTypeValue TAKE_HOME_TEST = new AtsDocumentApiModelTypeValue("take_home_test");
    public static final AtsDocumentApiModelTypeValue OFFER_LETTER = new AtsDocumentApiModelTypeValue("offer_letter");
    public static final AtsDocumentApiModelTypeValue SIGNED_OFFER_LETTER = new AtsDocumentApiModelTypeValue("signed_offer_letter");
    public static final AtsDocumentApiModelTypeValue NATIONAL_ID = new AtsDocumentApiModelTypeValue("national_id");
    public static final AtsDocumentApiModelTypeValue OFFER_PACKET = new AtsDocumentApiModelTypeValue("offer_packet");
    public static final AtsDocumentApiModelTypeValue OTHER = new AtsDocumentApiModelTypeValue("other");
    public static final AtsDocumentApiModelTypeValue UNMAPPED_VALUE = new AtsDocumentApiModelTypeValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, AtsDocumentApiModelTypeValue> values = createValuesMap();
    private static final Map<String, AtsDocumentApiModelTypeValueEnum> enums = createEnumsMap();

    private final String value;

    private AtsDocumentApiModelTypeValue(String value) {
        this.value = value;
    }

    /**
     * Returns a AtsDocumentApiModelTypeValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as AtsDocumentApiModelTypeValue
     */ 
    public static AtsDocumentApiModelTypeValue of(String value) {
        synchronized (AtsDocumentApiModelTypeValue.class) {
            return values.computeIfAbsent(value, v -> new AtsDocumentApiModelTypeValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<AtsDocumentApiModelTypeValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        AtsDocumentApiModelTypeValue other = (AtsDocumentApiModelTypeValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "AtsDocumentApiModelTypeValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static AtsDocumentApiModelTypeValue[] values() {
        synchronized (AtsDocumentApiModelTypeValue.class) {
            return values.values().toArray(new AtsDocumentApiModelTypeValue[] {});
        }
    }

    private static final Map<String, AtsDocumentApiModelTypeValue> createValuesMap() {
        Map<String, AtsDocumentApiModelTypeValue> map = new LinkedHashMap<>();
        map.put("resume", RESUME);
        map.put("avatar", AVATAR);
        map.put("cover_letter", COVER_LETTER);
        map.put("profile_picture", PROFILE_PICTURE);
        map.put("policy", POLICY);
        map.put("passport", PASSPORT);
        map.put("assessment", ASSESSMENT);
        map.put("interview_attachment", INTERVIEW_ATTACHMENT);
        map.put("take_home_test", TAKE_HOME_TEST);
        map.put("offer_letter", OFFER_LETTER);
        map.put("signed_offer_letter", SIGNED_OFFER_LETTER);
        map.put("national_id", NATIONAL_ID);
        map.put("offer_packet", OFFER_PACKET);
        map.put("other", OTHER);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, AtsDocumentApiModelTypeValueEnum> createEnumsMap() {
        Map<String, AtsDocumentApiModelTypeValueEnum> map = new HashMap<>();
        map.put("resume", AtsDocumentApiModelTypeValueEnum.RESUME);
        map.put("avatar", AtsDocumentApiModelTypeValueEnum.AVATAR);
        map.put("cover_letter", AtsDocumentApiModelTypeValueEnum.COVER_LETTER);
        map.put("profile_picture", AtsDocumentApiModelTypeValueEnum.PROFILE_PICTURE);
        map.put("policy", AtsDocumentApiModelTypeValueEnum.POLICY);
        map.put("passport", AtsDocumentApiModelTypeValueEnum.PASSPORT);
        map.put("assessment", AtsDocumentApiModelTypeValueEnum.ASSESSMENT);
        map.put("interview_attachment", AtsDocumentApiModelTypeValueEnum.INTERVIEW_ATTACHMENT);
        map.put("take_home_test", AtsDocumentApiModelTypeValueEnum.TAKE_HOME_TEST);
        map.put("offer_letter", AtsDocumentApiModelTypeValueEnum.OFFER_LETTER);
        map.put("signed_offer_letter", AtsDocumentApiModelTypeValueEnum.SIGNED_OFFER_LETTER);
        map.put("national_id", AtsDocumentApiModelTypeValueEnum.NATIONAL_ID);
        map.put("offer_packet", AtsDocumentApiModelTypeValueEnum.OFFER_PACKET);
        map.put("other", AtsDocumentApiModelTypeValueEnum.OTHER);
        map.put("unmapped_value", AtsDocumentApiModelTypeValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<AtsDocumentApiModelTypeValue> {

        protected _Serializer() {
            super(AtsDocumentApiModelTypeValue.class);
        }

        @Override
        public void serialize(AtsDocumentApiModelTypeValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<AtsDocumentApiModelTypeValue> {

        protected _Deserializer() {
            super(AtsDocumentApiModelTypeValue.class);
        }

        @Override
        public AtsDocumentApiModelTypeValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return AtsDocumentApiModelTypeValue.of(v);
        }
    }
    
    public enum AtsDocumentApiModelTypeValueEnum {

        RESUME("resume"),
        AVATAR("avatar"),
        COVER_LETTER("cover_letter"),
        PROFILE_PICTURE("profile_picture"),
        POLICY("policy"),
        PASSPORT("passport"),
        ASSESSMENT("assessment"),
        INTERVIEW_ATTACHMENT("interview_attachment"),
        TAKE_HOME_TEST("take_home_test"),
        OFFER_LETTER("offer_letter"),
        SIGNED_OFFER_LETTER("signed_offer_letter"),
        NATIONAL_ID("national_id"),
        OFFER_PACKET("offer_packet"),
        OTHER("other"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private AtsDocumentApiModelTypeValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

