/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.stackone.stackone_client_java.utils.LazySingletonValue;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Boolean;
import java.lang.Double;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;

public class ConnectSessionCreate {

    /**
     * The categories of the provider to connect to
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("categories")
    private JsonNullable<? extends List<Categories>> categories;

    /**
     * The provider to connect to
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("provider")
    private JsonNullable<String> provider;

    /**
     * The provider version to connect to
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("provider_version")
    private JsonNullable<String> providerVersion;

    /**
     * The origin owner identifier
     */
    @JsonProperty("origin_owner_id")
    private String originOwnerId;

    /**
     * The origin owner name
     */
    @JsonProperty("origin_owner_name")
    private String originOwnerName;

    /**
     * The origin username
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("origin_username")
    private JsonNullable<String> originUsername;

    /**
     * The unique identifier for the account associated with this connect session. When this field is present, the hub will launch in edit mode using the retrieved token.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("account_id")
    private JsonNullable<String> accountId;

    /**
     * How long the session should be valid for in seconds
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("expires_in")
    private JsonNullable<Double> expiresIn;

    /**
     * The metadata for the connection
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("metadata")
    private JsonNullable<? extends Metadata> metadata;

    /**
     * If set, this connect session will allow creation of multiple accounts with the same origin owner id and provider. Has no effect if account_id is set.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("multiple")
    private JsonNullable<Boolean> multiple;

    /**
     * The label to be applied to the account associated with this connect session.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("label")
    private JsonNullable<String> label;

    /**
     * The connect session account type
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("type")
    private JsonNullable<? extends Type> type;

    @JsonCreator
    public ConnectSessionCreate(
            @JsonProperty("categories") JsonNullable<? extends List<Categories>> categories,
            @JsonProperty("provider") JsonNullable<String> provider,
            @JsonProperty("provider_version") JsonNullable<String> providerVersion,
            @JsonProperty("origin_owner_id") String originOwnerId,
            @JsonProperty("origin_owner_name") String originOwnerName,
            @JsonProperty("origin_username") JsonNullable<String> originUsername,
            @JsonProperty("account_id") JsonNullable<String> accountId,
            @JsonProperty("expires_in") JsonNullable<Double> expiresIn,
            @JsonProperty("metadata") JsonNullable<? extends Metadata> metadata,
            @JsonProperty("multiple") JsonNullable<Boolean> multiple,
            @JsonProperty("label") JsonNullable<String> label,
            @JsonProperty("type") JsonNullable<? extends Type> type) {
        Utils.checkNotNull(categories, "categories");
        Utils.checkNotNull(provider, "provider");
        Utils.checkNotNull(providerVersion, "providerVersion");
        Utils.checkNotNull(originOwnerId, "originOwnerId");
        Utils.checkNotNull(originOwnerName, "originOwnerName");
        Utils.checkNotNull(originUsername, "originUsername");
        Utils.checkNotNull(accountId, "accountId");
        Utils.checkNotNull(expiresIn, "expiresIn");
        Utils.checkNotNull(metadata, "metadata");
        Utils.checkNotNull(multiple, "multiple");
        Utils.checkNotNull(label, "label");
        Utils.checkNotNull(type, "type");
        this.categories = categories;
        this.provider = provider;
        this.providerVersion = providerVersion;
        this.originOwnerId = originOwnerId;
        this.originOwnerName = originOwnerName;
        this.originUsername = originUsername;
        this.accountId = accountId;
        this.expiresIn = expiresIn;
        this.metadata = metadata;
        this.multiple = multiple;
        this.label = label;
        this.type = type;
    }
    
    public ConnectSessionCreate(
            String originOwnerId,
            String originOwnerName) {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), originOwnerId, originOwnerName, JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The categories of the provider to connect to
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<Categories>> categories() {
        return (JsonNullable<List<Categories>>) categories;
    }

    /**
     * The provider to connect to
     */
    @JsonIgnore
    public JsonNullable<String> provider() {
        return provider;
    }

    /**
     * The provider version to connect to
     */
    @JsonIgnore
    public JsonNullable<String> providerVersion() {
        return providerVersion;
    }

    /**
     * The origin owner identifier
     */
    @JsonIgnore
    public String originOwnerId() {
        return originOwnerId;
    }

    /**
     * The origin owner name
     */
    @JsonIgnore
    public String originOwnerName() {
        return originOwnerName;
    }

    /**
     * The origin username
     */
    @JsonIgnore
    public JsonNullable<String> originUsername() {
        return originUsername;
    }

    /**
     * The unique identifier for the account associated with this connect session. When this field is present, the hub will launch in edit mode using the retrieved token.
     */
    @JsonIgnore
    public JsonNullable<String> accountId() {
        return accountId;
    }

    /**
     * How long the session should be valid for in seconds
     */
    @JsonIgnore
    public JsonNullable<Double> expiresIn() {
        return expiresIn;
    }

    /**
     * The metadata for the connection
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Metadata> metadata() {
        return (JsonNullable<Metadata>) metadata;
    }

    /**
     * If set, this connect session will allow creation of multiple accounts with the same origin owner id and provider. Has no effect if account_id is set.
     */
    @JsonIgnore
    public JsonNullable<Boolean> multiple() {
        return multiple;
    }

    /**
     * The label to be applied to the account associated with this connect session.
     */
    @JsonIgnore
    public JsonNullable<String> label() {
        return label;
    }

    /**
     * The connect session account type
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Type> type() {
        return (JsonNullable<Type>) type;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The categories of the provider to connect to
     */
    public ConnectSessionCreate withCategories(List<Categories> categories) {
        Utils.checkNotNull(categories, "categories");
        this.categories = JsonNullable.of(categories);
        return this;
    }

    /**
     * The categories of the provider to connect to
     */
    public ConnectSessionCreate withCategories(JsonNullable<? extends List<Categories>> categories) {
        Utils.checkNotNull(categories, "categories");
        this.categories = categories;
        return this;
    }

    /**
     * The provider to connect to
     */
    public ConnectSessionCreate withProvider(String provider) {
        Utils.checkNotNull(provider, "provider");
        this.provider = JsonNullable.of(provider);
        return this;
    }

    /**
     * The provider to connect to
     */
    public ConnectSessionCreate withProvider(JsonNullable<String> provider) {
        Utils.checkNotNull(provider, "provider");
        this.provider = provider;
        return this;
    }

    /**
     * The provider version to connect to
     */
    public ConnectSessionCreate withProviderVersion(String providerVersion) {
        Utils.checkNotNull(providerVersion, "providerVersion");
        this.providerVersion = JsonNullable.of(providerVersion);
        return this;
    }

    /**
     * The provider version to connect to
     */
    public ConnectSessionCreate withProviderVersion(JsonNullable<String> providerVersion) {
        Utils.checkNotNull(providerVersion, "providerVersion");
        this.providerVersion = providerVersion;
        return this;
    }

    /**
     * The origin owner identifier
     */
    public ConnectSessionCreate withOriginOwnerId(String originOwnerId) {
        Utils.checkNotNull(originOwnerId, "originOwnerId");
        this.originOwnerId = originOwnerId;
        return this;
    }

    /**
     * The origin owner name
     */
    public ConnectSessionCreate withOriginOwnerName(String originOwnerName) {
        Utils.checkNotNull(originOwnerName, "originOwnerName");
        this.originOwnerName = originOwnerName;
        return this;
    }

    /**
     * The origin username
     */
    public ConnectSessionCreate withOriginUsername(String originUsername) {
        Utils.checkNotNull(originUsername, "originUsername");
        this.originUsername = JsonNullable.of(originUsername);
        return this;
    }

    /**
     * The origin username
     */
    public ConnectSessionCreate withOriginUsername(JsonNullable<String> originUsername) {
        Utils.checkNotNull(originUsername, "originUsername");
        this.originUsername = originUsername;
        return this;
    }

    /**
     * The unique identifier for the account associated with this connect session. When this field is present, the hub will launch in edit mode using the retrieved token.
     */
    public ConnectSessionCreate withAccountId(String accountId) {
        Utils.checkNotNull(accountId, "accountId");
        this.accountId = JsonNullable.of(accountId);
        return this;
    }

    /**
     * The unique identifier for the account associated with this connect session. When this field is present, the hub will launch in edit mode using the retrieved token.
     */
    public ConnectSessionCreate withAccountId(JsonNullable<String> accountId) {
        Utils.checkNotNull(accountId, "accountId");
        this.accountId = accountId;
        return this;
    }

    /**
     * How long the session should be valid for in seconds
     */
    public ConnectSessionCreate withExpiresIn(double expiresIn) {
        Utils.checkNotNull(expiresIn, "expiresIn");
        this.expiresIn = JsonNullable.of(expiresIn);
        return this;
    }

    /**
     * How long the session should be valid for in seconds
     */
    public ConnectSessionCreate withExpiresIn(JsonNullable<Double> expiresIn) {
        Utils.checkNotNull(expiresIn, "expiresIn");
        this.expiresIn = expiresIn;
        return this;
    }

    /**
     * The metadata for the connection
     */
    public ConnectSessionCreate withMetadata(Metadata metadata) {
        Utils.checkNotNull(metadata, "metadata");
        this.metadata = JsonNullable.of(metadata);
        return this;
    }

    /**
     * The metadata for the connection
     */
    public ConnectSessionCreate withMetadata(JsonNullable<? extends Metadata> metadata) {
        Utils.checkNotNull(metadata, "metadata");
        this.metadata = metadata;
        return this;
    }

    /**
     * If set, this connect session will allow creation of multiple accounts with the same origin owner id and provider. Has no effect if account_id is set.
     */
    public ConnectSessionCreate withMultiple(boolean multiple) {
        Utils.checkNotNull(multiple, "multiple");
        this.multiple = JsonNullable.of(multiple);
        return this;
    }

    /**
     * If set, this connect session will allow creation of multiple accounts with the same origin owner id and provider. Has no effect if account_id is set.
     */
    public ConnectSessionCreate withMultiple(JsonNullable<Boolean> multiple) {
        Utils.checkNotNull(multiple, "multiple");
        this.multiple = multiple;
        return this;
    }

    /**
     * The label to be applied to the account associated with this connect session.
     */
    public ConnectSessionCreate withLabel(String label) {
        Utils.checkNotNull(label, "label");
        this.label = JsonNullable.of(label);
        return this;
    }

    /**
     * The label to be applied to the account associated with this connect session.
     */
    public ConnectSessionCreate withLabel(JsonNullable<String> label) {
        Utils.checkNotNull(label, "label");
        this.label = label;
        return this;
    }

    /**
     * The connect session account type
     */
    public ConnectSessionCreate withType(Type type) {
        Utils.checkNotNull(type, "type");
        this.type = JsonNullable.of(type);
        return this;
    }

    /**
     * The connect session account type
     */
    public ConnectSessionCreate withType(JsonNullable<? extends Type> type) {
        Utils.checkNotNull(type, "type");
        this.type = type;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ConnectSessionCreate other = (ConnectSessionCreate) o;
        return 
            Utils.enhancedDeepEquals(this.categories, other.categories) &&
            Utils.enhancedDeepEquals(this.provider, other.provider) &&
            Utils.enhancedDeepEquals(this.providerVersion, other.providerVersion) &&
            Utils.enhancedDeepEquals(this.originOwnerId, other.originOwnerId) &&
            Utils.enhancedDeepEquals(this.originOwnerName, other.originOwnerName) &&
            Utils.enhancedDeepEquals(this.originUsername, other.originUsername) &&
            Utils.enhancedDeepEquals(this.accountId, other.accountId) &&
            Utils.enhancedDeepEquals(this.expiresIn, other.expiresIn) &&
            Utils.enhancedDeepEquals(this.metadata, other.metadata) &&
            Utils.enhancedDeepEquals(this.multiple, other.multiple) &&
            Utils.enhancedDeepEquals(this.label, other.label) &&
            Utils.enhancedDeepEquals(this.type, other.type);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            categories,
            provider,
            providerVersion,
            originOwnerId,
            originOwnerName,
            originUsername,
            accountId,
            expiresIn,
            metadata,
            multiple,
            label,
            type);
    }
    
    @Override
    public String toString() {
        return Utils.toString(ConnectSessionCreate.class,
                "categories", categories,
                "provider", provider,
                "providerVersion", providerVersion,
                "originOwnerId", originOwnerId,
                "originOwnerName", originOwnerName,
                "originUsername", originUsername,
                "accountId", accountId,
                "expiresIn", expiresIn,
                "metadata", metadata,
                "multiple", multiple,
                "label", label,
                "type", type);
    }
    
    public final static class Builder {
 
        private JsonNullable<? extends List<Categories>> categories = JsonNullable.undefined();
 
        private JsonNullable<String> provider = JsonNullable.undefined();
 
        private JsonNullable<String> providerVersion = JsonNullable.undefined();
 
        private String originOwnerId;
 
        private String originOwnerName;
 
        private JsonNullable<String> originUsername = JsonNullable.undefined();
 
        private JsonNullable<String> accountId = JsonNullable.undefined();
 
        private JsonNullable<Double> expiresIn;
 
        private JsonNullable<? extends Metadata> metadata = JsonNullable.undefined();
 
        private JsonNullable<Boolean> multiple;
 
        private JsonNullable<String> label = JsonNullable.undefined();
 
        private JsonNullable<? extends Type> type;
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The categories of the provider to connect to
         */
        public Builder categories(List<Categories> categories) {
            Utils.checkNotNull(categories, "categories");
            this.categories = JsonNullable.of(categories);
            return this;
        }

        /**
         * The categories of the provider to connect to
         */
        public Builder categories(JsonNullable<? extends List<Categories>> categories) {
            Utils.checkNotNull(categories, "categories");
            this.categories = categories;
            return this;
        }

        /**
         * The provider to connect to
         */
        public Builder provider(String provider) {
            Utils.checkNotNull(provider, "provider");
            this.provider = JsonNullable.of(provider);
            return this;
        }

        /**
         * The provider to connect to
         */
        public Builder provider(JsonNullable<String> provider) {
            Utils.checkNotNull(provider, "provider");
            this.provider = provider;
            return this;
        }

        /**
         * The provider version to connect to
         */
        public Builder providerVersion(String providerVersion) {
            Utils.checkNotNull(providerVersion, "providerVersion");
            this.providerVersion = JsonNullable.of(providerVersion);
            return this;
        }

        /**
         * The provider version to connect to
         */
        public Builder providerVersion(JsonNullable<String> providerVersion) {
            Utils.checkNotNull(providerVersion, "providerVersion");
            this.providerVersion = providerVersion;
            return this;
        }

        /**
         * The origin owner identifier
         */
        public Builder originOwnerId(String originOwnerId) {
            Utils.checkNotNull(originOwnerId, "originOwnerId");
            this.originOwnerId = originOwnerId;
            return this;
        }

        /**
         * The origin owner name
         */
        public Builder originOwnerName(String originOwnerName) {
            Utils.checkNotNull(originOwnerName, "originOwnerName");
            this.originOwnerName = originOwnerName;
            return this;
        }

        /**
         * The origin username
         */
        public Builder originUsername(String originUsername) {
            Utils.checkNotNull(originUsername, "originUsername");
            this.originUsername = JsonNullable.of(originUsername);
            return this;
        }

        /**
         * The origin username
         */
        public Builder originUsername(JsonNullable<String> originUsername) {
            Utils.checkNotNull(originUsername, "originUsername");
            this.originUsername = originUsername;
            return this;
        }

        /**
         * The unique identifier for the account associated with this connect session. When this field is present, the hub will launch in edit mode using the retrieved token.
         */
        public Builder accountId(String accountId) {
            Utils.checkNotNull(accountId, "accountId");
            this.accountId = JsonNullable.of(accountId);
            return this;
        }

        /**
         * The unique identifier for the account associated with this connect session. When this field is present, the hub will launch in edit mode using the retrieved token.
         */
        public Builder accountId(JsonNullable<String> accountId) {
            Utils.checkNotNull(accountId, "accountId");
            this.accountId = accountId;
            return this;
        }

        /**
         * How long the session should be valid for in seconds
         */
        public Builder expiresIn(double expiresIn) {
            Utils.checkNotNull(expiresIn, "expiresIn");
            this.expiresIn = JsonNullable.of(expiresIn);
            return this;
        }

        /**
         * How long the session should be valid for in seconds
         */
        public Builder expiresIn(JsonNullable<Double> expiresIn) {
            Utils.checkNotNull(expiresIn, "expiresIn");
            this.expiresIn = expiresIn;
            return this;
        }

        /**
         * The metadata for the connection
         */
        public Builder metadata(Metadata metadata) {
            Utils.checkNotNull(metadata, "metadata");
            this.metadata = JsonNullable.of(metadata);
            return this;
        }

        /**
         * The metadata for the connection
         */
        public Builder metadata(JsonNullable<? extends Metadata> metadata) {
            Utils.checkNotNull(metadata, "metadata");
            this.metadata = metadata;
            return this;
        }

        /**
         * If set, this connect session will allow creation of multiple accounts with the same origin owner id and provider. Has no effect if account_id is set.
         */
        public Builder multiple(boolean multiple) {
            Utils.checkNotNull(multiple, "multiple");
            this.multiple = JsonNullable.of(multiple);
            return this;
        }

        /**
         * If set, this connect session will allow creation of multiple accounts with the same origin owner id and provider. Has no effect if account_id is set.
         */
        public Builder multiple(JsonNullable<Boolean> multiple) {
            Utils.checkNotNull(multiple, "multiple");
            this.multiple = multiple;
            return this;
        }

        /**
         * The label to be applied to the account associated with this connect session.
         */
        public Builder label(String label) {
            Utils.checkNotNull(label, "label");
            this.label = JsonNullable.of(label);
            return this;
        }

        /**
         * The label to be applied to the account associated with this connect session.
         */
        public Builder label(JsonNullable<String> label) {
            Utils.checkNotNull(label, "label");
            this.label = label;
            return this;
        }

        /**
         * The connect session account type
         */
        public Builder type(Type type) {
            Utils.checkNotNull(type, "type");
            this.type = JsonNullable.of(type);
            return this;
        }

        /**
         * The connect session account type
         */
        public Builder type(JsonNullable<? extends Type> type) {
            Utils.checkNotNull(type, "type");
            this.type = type;
            return this;
        }
        
        public ConnectSessionCreate build() {
            if (expiresIn == null) {
                expiresIn = _SINGLETON_VALUE_ExpiresIn.value();
            }
            if (multiple == null) {
                multiple = _SINGLETON_VALUE_Multiple.value();
            }
            if (type == null) {
                type = _SINGLETON_VALUE_Type.value();
            }
            return new ConnectSessionCreate(
                categories,
                provider,
                providerVersion,
                originOwnerId,
                originOwnerName,
                originUsername,
                accountId,
                expiresIn,
                metadata,
                multiple,
                label,
                type);
        }

        private static final LazySingletonValue<JsonNullable<Double>> _SINGLETON_VALUE_ExpiresIn =
                new LazySingletonValue<>(
                        "expires_in",
                        "1800",
                        new TypeReference<JsonNullable<Double>>() {});

        private static final LazySingletonValue<JsonNullable<Boolean>> _SINGLETON_VALUE_Multiple =
                new LazySingletonValue<>(
                        "multiple",
                        "false",
                        new TypeReference<JsonNullable<Boolean>>() {});

        private static final LazySingletonValue<JsonNullable<? extends Type>> _SINGLETON_VALUE_Type =
                new LazySingletonValue<>(
                        "type",
                        "\"production\"",
                        new TypeReference<JsonNullable<? extends Type>>() {});
    }
}
