/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * CreateEmploymentApiModelPayFrequencyValue
 * 
 * <p>The pay frequency of the job postings.
 */
@JsonDeserialize(using = CreateEmploymentApiModelPayFrequencyValue._Deserializer.class)
@JsonSerialize(using = CreateEmploymentApiModelPayFrequencyValue._Serializer.class)
public class CreateEmploymentApiModelPayFrequencyValue {

    public static final CreateEmploymentApiModelPayFrequencyValue HOURLY = new CreateEmploymentApiModelPayFrequencyValue("hourly");
    public static final CreateEmploymentApiModelPayFrequencyValue WEEKLY = new CreateEmploymentApiModelPayFrequencyValue("weekly");
    public static final CreateEmploymentApiModelPayFrequencyValue BI_WEEKLY = new CreateEmploymentApiModelPayFrequencyValue("bi_weekly");
    public static final CreateEmploymentApiModelPayFrequencyValue FOUR_WEEKLY = new CreateEmploymentApiModelPayFrequencyValue("four_weekly");
    public static final CreateEmploymentApiModelPayFrequencyValue SEMI_MONTHLY = new CreateEmploymentApiModelPayFrequencyValue("semi_monthly");
    public static final CreateEmploymentApiModelPayFrequencyValue MONTHLY = new CreateEmploymentApiModelPayFrequencyValue("monthly");
    public static final CreateEmploymentApiModelPayFrequencyValue BI_MONTHLY = new CreateEmploymentApiModelPayFrequencyValue("bi_monthly");
    public static final CreateEmploymentApiModelPayFrequencyValue QUARTERLY = new CreateEmploymentApiModelPayFrequencyValue("quarterly");
    public static final CreateEmploymentApiModelPayFrequencyValue SEMI_ANNUALLY = new CreateEmploymentApiModelPayFrequencyValue("semi_annually");
    public static final CreateEmploymentApiModelPayFrequencyValue YEARLY = new CreateEmploymentApiModelPayFrequencyValue("yearly");
    public static final CreateEmploymentApiModelPayFrequencyValue THIRTEEN_MONTHLY = new CreateEmploymentApiModelPayFrequencyValue("thirteen_monthly");
    public static final CreateEmploymentApiModelPayFrequencyValue PRO_RATA = new CreateEmploymentApiModelPayFrequencyValue("pro_rata");
    public static final CreateEmploymentApiModelPayFrequencyValue UNMAPPED_VALUE = new CreateEmploymentApiModelPayFrequencyValue("unmapped_value");
    public static final CreateEmploymentApiModelPayFrequencyValue HALF_YEARLY = new CreateEmploymentApiModelPayFrequencyValue("half_yearly");
    public static final CreateEmploymentApiModelPayFrequencyValue DAILY = new CreateEmploymentApiModelPayFrequencyValue("daily");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, CreateEmploymentApiModelPayFrequencyValue> values = createValuesMap();
    private static final Map<String, CreateEmploymentApiModelPayFrequencyValueEnum> enums = createEnumsMap();

    private final String value;

    private CreateEmploymentApiModelPayFrequencyValue(String value) {
        this.value = value;
    }

    /**
     * Returns a CreateEmploymentApiModelPayFrequencyValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as CreateEmploymentApiModelPayFrequencyValue
     */ 
    public static CreateEmploymentApiModelPayFrequencyValue of(String value) {
        synchronized (CreateEmploymentApiModelPayFrequencyValue.class) {
            return values.computeIfAbsent(value, v -> new CreateEmploymentApiModelPayFrequencyValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<CreateEmploymentApiModelPayFrequencyValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        CreateEmploymentApiModelPayFrequencyValue other = (CreateEmploymentApiModelPayFrequencyValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "CreateEmploymentApiModelPayFrequencyValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static CreateEmploymentApiModelPayFrequencyValue[] values() {
        synchronized (CreateEmploymentApiModelPayFrequencyValue.class) {
            return values.values().toArray(new CreateEmploymentApiModelPayFrequencyValue[] {});
        }
    }

    private static final Map<String, CreateEmploymentApiModelPayFrequencyValue> createValuesMap() {
        Map<String, CreateEmploymentApiModelPayFrequencyValue> map = new LinkedHashMap<>();
        map.put("hourly", HOURLY);
        map.put("weekly", WEEKLY);
        map.put("bi_weekly", BI_WEEKLY);
        map.put("four_weekly", FOUR_WEEKLY);
        map.put("semi_monthly", SEMI_MONTHLY);
        map.put("monthly", MONTHLY);
        map.put("bi_monthly", BI_MONTHLY);
        map.put("quarterly", QUARTERLY);
        map.put("semi_annually", SEMI_ANNUALLY);
        map.put("yearly", YEARLY);
        map.put("thirteen_monthly", THIRTEEN_MONTHLY);
        map.put("pro_rata", PRO_RATA);
        map.put("unmapped_value", UNMAPPED_VALUE);
        map.put("half_yearly", HALF_YEARLY);
        map.put("daily", DAILY);
        return map;
    }

    private static final Map<String, CreateEmploymentApiModelPayFrequencyValueEnum> createEnumsMap() {
        Map<String, CreateEmploymentApiModelPayFrequencyValueEnum> map = new HashMap<>();
        map.put("hourly", CreateEmploymentApiModelPayFrequencyValueEnum.HOURLY);
        map.put("weekly", CreateEmploymentApiModelPayFrequencyValueEnum.WEEKLY);
        map.put("bi_weekly", CreateEmploymentApiModelPayFrequencyValueEnum.BI_WEEKLY);
        map.put("four_weekly", CreateEmploymentApiModelPayFrequencyValueEnum.FOUR_WEEKLY);
        map.put("semi_monthly", CreateEmploymentApiModelPayFrequencyValueEnum.SEMI_MONTHLY);
        map.put("monthly", CreateEmploymentApiModelPayFrequencyValueEnum.MONTHLY);
        map.put("bi_monthly", CreateEmploymentApiModelPayFrequencyValueEnum.BI_MONTHLY);
        map.put("quarterly", CreateEmploymentApiModelPayFrequencyValueEnum.QUARTERLY);
        map.put("semi_annually", CreateEmploymentApiModelPayFrequencyValueEnum.SEMI_ANNUALLY);
        map.put("yearly", CreateEmploymentApiModelPayFrequencyValueEnum.YEARLY);
        map.put("thirteen_monthly", CreateEmploymentApiModelPayFrequencyValueEnum.THIRTEEN_MONTHLY);
        map.put("pro_rata", CreateEmploymentApiModelPayFrequencyValueEnum.PRO_RATA);
        map.put("unmapped_value", CreateEmploymentApiModelPayFrequencyValueEnum.UNMAPPED_VALUE);
        map.put("half_yearly", CreateEmploymentApiModelPayFrequencyValueEnum.HALF_YEARLY);
        map.put("daily", CreateEmploymentApiModelPayFrequencyValueEnum.DAILY);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<CreateEmploymentApiModelPayFrequencyValue> {

        protected _Serializer() {
            super(CreateEmploymentApiModelPayFrequencyValue.class);
        }

        @Override
        public void serialize(CreateEmploymentApiModelPayFrequencyValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<CreateEmploymentApiModelPayFrequencyValue> {

        protected _Deserializer() {
            super(CreateEmploymentApiModelPayFrequencyValue.class);
        }

        @Override
        public CreateEmploymentApiModelPayFrequencyValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return CreateEmploymentApiModelPayFrequencyValue.of(v);
        }
    }
    
    public enum CreateEmploymentApiModelPayFrequencyValueEnum {

        HOURLY("hourly"),
        WEEKLY("weekly"),
        BI_WEEKLY("bi_weekly"),
        FOUR_WEEKLY("four_weekly"),
        SEMI_MONTHLY("semi_monthly"),
        MONTHLY("monthly"),
        BI_MONTHLY("bi_monthly"),
        QUARTERLY("quarterly"),
        SEMI_ANNUALLY("semi_annually"),
        YEARLY("yearly"),
        THIRTEEN_MONTHLY("thirteen_monthly"),
        PRO_RATA("pro_rata"),
        UNMAPPED_VALUE("unmapped_value"),
        HALF_YEARLY("half_yearly"),
        DAILY("daily"),;

        private final String value;

        private CreateEmploymentApiModelPayFrequencyValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

