/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * EmployeeCountry
 * 
 * <p>The country code
 */
public class EmployeeCountry {

    /**
     * The ISO3166-1 Alpha2 Code of the Country
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends EmployeeWorkLocationValue> value;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends EmployeeWorkLocationSourceValue> sourceValue;

    @JsonCreator
    public EmployeeCountry(
            @JsonProperty("value") JsonNullable<? extends EmployeeWorkLocationValue> value,
            @JsonProperty("source_value") JsonNullable<? extends EmployeeWorkLocationSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public EmployeeCountry() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The ISO3166-1 Alpha2 Code of the Country
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<EmployeeWorkLocationValue> value() {
        return (JsonNullable<EmployeeWorkLocationValue>) value;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<EmployeeWorkLocationSourceValue> sourceValue() {
        return (JsonNullable<EmployeeWorkLocationSourceValue>) sourceValue;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The ISO3166-1 Alpha2 Code of the Country
     */
    public EmployeeCountry withValue(EmployeeWorkLocationValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The ISO3166-1 Alpha2 Code of the Country
     */
    public EmployeeCountry withValue(JsonNullable<? extends EmployeeWorkLocationValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public EmployeeCountry withSourceValue(EmployeeWorkLocationSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    public EmployeeCountry withSourceValue(JsonNullable<? extends EmployeeWorkLocationSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        EmployeeCountry other = (EmployeeCountry) o;
        return 
            Utils.enhancedDeepEquals(this.value, other.value) &&
            Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            value,
            sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(EmployeeCountry.class,
                "value", value,
                "sourceValue", sourceValue);
    }
    
    public final static class Builder {
 
        private JsonNullable<? extends EmployeeWorkLocationValue> value = JsonNullable.undefined();
 
        private JsonNullable<? extends EmployeeWorkLocationSourceValue> sourceValue = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The ISO3166-1 Alpha2 Code of the Country
         */
        public Builder value(EmployeeWorkLocationValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The ISO3166-1 Alpha2 Code of the Country
         */
        public Builder value(JsonNullable<? extends EmployeeWorkLocationValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public Builder sourceValue(EmployeeWorkLocationSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends EmployeeWorkLocationSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }
        
        public EmployeeCountry build() {
            return new EmployeeCountry(
                value,
                sourceValue);
        }
    }
}
