/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * HrisUpdateEmployeeRequestDtoHomeLocation
 * 
 * <p>The employee home location
 */
public class HrisUpdateEmployeeRequestDtoHomeLocation {

    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * The name of the location
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("name")
    private JsonNullable<String> name;

    /**
     * The phone number of the location
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("phone_number")
    private JsonNullable<String> phoneNumber;

    /**
     * The first line of the address
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("street_1")
    private JsonNullable<String> street1;

    /**
     * The second line of the address
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("street_2")
    private JsonNullable<String> street2;

    /**
     * The city where the location is situated
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("city")
    private JsonNullable<String> city;

    /**
     * The ZIP code/Postal code of the location
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("zip_code")
    private JsonNullable<String> zipCode;

    /**
     * The country code
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("country")
    private JsonNullable<? extends HrisUpdateEmployeeRequestDtoHomeLocationCountry> country;

    /**
     * Value to pass through to the provider
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("passthrough")
    private JsonNullable<? extends Map<String, Object>> passthrough;

    /**
     * The ISO3166-2 sub division where the location is situated
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("state")
    private JsonNullable<? extends HrisUpdateEmployeeRequestDtoState> state;

    @JsonCreator
    public HrisUpdateEmployeeRequestDtoHomeLocation(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("name") JsonNullable<String> name,
            @JsonProperty("phone_number") JsonNullable<String> phoneNumber,
            @JsonProperty("street_1") JsonNullable<String> street1,
            @JsonProperty("street_2") JsonNullable<String> street2,
            @JsonProperty("city") JsonNullable<String> city,
            @JsonProperty("zip_code") JsonNullable<String> zipCode,
            @JsonProperty("country") JsonNullable<? extends HrisUpdateEmployeeRequestDtoHomeLocationCountry> country,
            @JsonProperty("passthrough") JsonNullable<? extends Map<String, Object>> passthrough,
            @JsonProperty("state") JsonNullable<? extends HrisUpdateEmployeeRequestDtoState> state) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(phoneNumber, "phoneNumber");
        Utils.checkNotNull(street1, "street1");
        Utils.checkNotNull(street2, "street2");
        Utils.checkNotNull(city, "city");
        Utils.checkNotNull(zipCode, "zipCode");
        Utils.checkNotNull(country, "country");
        Utils.checkNotNull(passthrough, "passthrough");
        Utils.checkNotNull(state, "state");
        this.id = id;
        this.name = name;
        this.phoneNumber = phoneNumber;
        this.street1 = street1;
        this.street2 = street2;
        this.city = city;
        this.zipCode = zipCode;
        this.country = country;
        this.passthrough = passthrough;
        this.state = state;
    }
    
    public HrisUpdateEmployeeRequestDtoHomeLocation() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * The name of the location
     */
    @JsonIgnore
    public JsonNullable<String> name() {
        return name;
    }

    /**
     * The phone number of the location
     */
    @JsonIgnore
    public JsonNullable<String> phoneNumber() {
        return phoneNumber;
    }

    /**
     * The first line of the address
     */
    @JsonIgnore
    public JsonNullable<String> street1() {
        return street1;
    }

    /**
     * The second line of the address
     */
    @JsonIgnore
    public JsonNullable<String> street2() {
        return street2;
    }

    /**
     * The city where the location is situated
     */
    @JsonIgnore
    public JsonNullable<String> city() {
        return city;
    }

    /**
     * The ZIP code/Postal code of the location
     */
    @JsonIgnore
    public JsonNullable<String> zipCode() {
        return zipCode;
    }

    /**
     * The country code
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<HrisUpdateEmployeeRequestDtoHomeLocationCountry> country() {
        return (JsonNullable<HrisUpdateEmployeeRequestDtoHomeLocationCountry>) country;
    }

    /**
     * Value to pass through to the provider
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> passthrough() {
        return (JsonNullable<Map<String, Object>>) passthrough;
    }

    /**
     * The ISO3166-2 sub division where the location is situated
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<HrisUpdateEmployeeRequestDtoState> state() {
        return (JsonNullable<HrisUpdateEmployeeRequestDtoState>) state;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * Unique identifier
     */
    public HrisUpdateEmployeeRequestDtoHomeLocation withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public HrisUpdateEmployeeRequestDtoHomeLocation withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * The name of the location
     */
    public HrisUpdateEmployeeRequestDtoHomeLocation withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = JsonNullable.of(name);
        return this;
    }

    /**
     * The name of the location
     */
    public HrisUpdateEmployeeRequestDtoHomeLocation withName(JsonNullable<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    /**
     * The phone number of the location
     */
    public HrisUpdateEmployeeRequestDtoHomeLocation withPhoneNumber(String phoneNumber) {
        Utils.checkNotNull(phoneNumber, "phoneNumber");
        this.phoneNumber = JsonNullable.of(phoneNumber);
        return this;
    }

    /**
     * The phone number of the location
     */
    public HrisUpdateEmployeeRequestDtoHomeLocation withPhoneNumber(JsonNullable<String> phoneNumber) {
        Utils.checkNotNull(phoneNumber, "phoneNumber");
        this.phoneNumber = phoneNumber;
        return this;
    }

    /**
     * The first line of the address
     */
    public HrisUpdateEmployeeRequestDtoHomeLocation withStreet1(String street1) {
        Utils.checkNotNull(street1, "street1");
        this.street1 = JsonNullable.of(street1);
        return this;
    }

    /**
     * The first line of the address
     */
    public HrisUpdateEmployeeRequestDtoHomeLocation withStreet1(JsonNullable<String> street1) {
        Utils.checkNotNull(street1, "street1");
        this.street1 = street1;
        return this;
    }

    /**
     * The second line of the address
     */
    public HrisUpdateEmployeeRequestDtoHomeLocation withStreet2(String street2) {
        Utils.checkNotNull(street2, "street2");
        this.street2 = JsonNullable.of(street2);
        return this;
    }

    /**
     * The second line of the address
     */
    public HrisUpdateEmployeeRequestDtoHomeLocation withStreet2(JsonNullable<String> street2) {
        Utils.checkNotNull(street2, "street2");
        this.street2 = street2;
        return this;
    }

    /**
     * The city where the location is situated
     */
    public HrisUpdateEmployeeRequestDtoHomeLocation withCity(String city) {
        Utils.checkNotNull(city, "city");
        this.city = JsonNullable.of(city);
        return this;
    }

    /**
     * The city where the location is situated
     */
    public HrisUpdateEmployeeRequestDtoHomeLocation withCity(JsonNullable<String> city) {
        Utils.checkNotNull(city, "city");
        this.city = city;
        return this;
    }

    /**
     * The ZIP code/Postal code of the location
     */
    public HrisUpdateEmployeeRequestDtoHomeLocation withZipCode(String zipCode) {
        Utils.checkNotNull(zipCode, "zipCode");
        this.zipCode = JsonNullable.of(zipCode);
        return this;
    }

    /**
     * The ZIP code/Postal code of the location
     */
    public HrisUpdateEmployeeRequestDtoHomeLocation withZipCode(JsonNullable<String> zipCode) {
        Utils.checkNotNull(zipCode, "zipCode");
        this.zipCode = zipCode;
        return this;
    }

    /**
     * The country code
     */
    public HrisUpdateEmployeeRequestDtoHomeLocation withCountry(HrisUpdateEmployeeRequestDtoHomeLocationCountry country) {
        Utils.checkNotNull(country, "country");
        this.country = JsonNullable.of(country);
        return this;
    }

    /**
     * The country code
     */
    public HrisUpdateEmployeeRequestDtoHomeLocation withCountry(JsonNullable<? extends HrisUpdateEmployeeRequestDtoHomeLocationCountry> country) {
        Utils.checkNotNull(country, "country");
        this.country = country;
        return this;
    }

    /**
     * Value to pass through to the provider
     */
    public HrisUpdateEmployeeRequestDtoHomeLocation withPassthrough(Map<String, Object> passthrough) {
        Utils.checkNotNull(passthrough, "passthrough");
        this.passthrough = JsonNullable.of(passthrough);
        return this;
    }

    /**
     * Value to pass through to the provider
     */
    public HrisUpdateEmployeeRequestDtoHomeLocation withPassthrough(JsonNullable<? extends Map<String, Object>> passthrough) {
        Utils.checkNotNull(passthrough, "passthrough");
        this.passthrough = passthrough;
        return this;
    }

    /**
     * The ISO3166-2 sub division where the location is situated
     */
    public HrisUpdateEmployeeRequestDtoHomeLocation withState(HrisUpdateEmployeeRequestDtoState state) {
        Utils.checkNotNull(state, "state");
        this.state = JsonNullable.of(state);
        return this;
    }

    /**
     * The ISO3166-2 sub division where the location is situated
     */
    public HrisUpdateEmployeeRequestDtoHomeLocation withState(JsonNullable<? extends HrisUpdateEmployeeRequestDtoState> state) {
        Utils.checkNotNull(state, "state");
        this.state = state;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        HrisUpdateEmployeeRequestDtoHomeLocation other = (HrisUpdateEmployeeRequestDtoHomeLocation) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.name, other.name) &&
            Utils.enhancedDeepEquals(this.phoneNumber, other.phoneNumber) &&
            Utils.enhancedDeepEquals(this.street1, other.street1) &&
            Utils.enhancedDeepEquals(this.street2, other.street2) &&
            Utils.enhancedDeepEquals(this.city, other.city) &&
            Utils.enhancedDeepEquals(this.zipCode, other.zipCode) &&
            Utils.enhancedDeepEquals(this.country, other.country) &&
            Utils.enhancedDeepEquals(this.passthrough, other.passthrough) &&
            Utils.enhancedDeepEquals(this.state, other.state);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id,
            name,
            phoneNumber,
            street1,
            street2,
            city,
            zipCode,
            country,
            passthrough,
            state);
    }
    
    @Override
    public String toString() {
        return Utils.toString(HrisUpdateEmployeeRequestDtoHomeLocation.class,
                "id", id,
                "name", name,
                "phoneNumber", phoneNumber,
                "street1", street1,
                "street2", street2,
                "city", city,
                "zipCode", zipCode,
                "country", country,
                "passthrough", passthrough,
                "state", state);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> id = JsonNullable.undefined();
 
        private JsonNullable<String> name = JsonNullable.undefined();
 
        private JsonNullable<String> phoneNumber = JsonNullable.undefined();
 
        private JsonNullable<String> street1 = JsonNullable.undefined();
 
        private JsonNullable<String> street2 = JsonNullable.undefined();
 
        private JsonNullable<String> city = JsonNullable.undefined();
 
        private JsonNullable<String> zipCode = JsonNullable.undefined();
 
        private JsonNullable<? extends HrisUpdateEmployeeRequestDtoHomeLocationCountry> country = JsonNullable.undefined();
 
        private JsonNullable<? extends Map<String, Object>> passthrough = JsonNullable.undefined();
 
        private JsonNullable<? extends HrisUpdateEmployeeRequestDtoState> state = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        /**
         * The name of the location
         */
        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = JsonNullable.of(name);
            return this;
        }

        /**
         * The name of the location
         */
        public Builder name(JsonNullable<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        /**
         * The phone number of the location
         */
        public Builder phoneNumber(String phoneNumber) {
            Utils.checkNotNull(phoneNumber, "phoneNumber");
            this.phoneNumber = JsonNullable.of(phoneNumber);
            return this;
        }

        /**
         * The phone number of the location
         */
        public Builder phoneNumber(JsonNullable<String> phoneNumber) {
            Utils.checkNotNull(phoneNumber, "phoneNumber");
            this.phoneNumber = phoneNumber;
            return this;
        }

        /**
         * The first line of the address
         */
        public Builder street1(String street1) {
            Utils.checkNotNull(street1, "street1");
            this.street1 = JsonNullable.of(street1);
            return this;
        }

        /**
         * The first line of the address
         */
        public Builder street1(JsonNullable<String> street1) {
            Utils.checkNotNull(street1, "street1");
            this.street1 = street1;
            return this;
        }

        /**
         * The second line of the address
         */
        public Builder street2(String street2) {
            Utils.checkNotNull(street2, "street2");
            this.street2 = JsonNullable.of(street2);
            return this;
        }

        /**
         * The second line of the address
         */
        public Builder street2(JsonNullable<String> street2) {
            Utils.checkNotNull(street2, "street2");
            this.street2 = street2;
            return this;
        }

        /**
         * The city where the location is situated
         */
        public Builder city(String city) {
            Utils.checkNotNull(city, "city");
            this.city = JsonNullable.of(city);
            return this;
        }

        /**
         * The city where the location is situated
         */
        public Builder city(JsonNullable<String> city) {
            Utils.checkNotNull(city, "city");
            this.city = city;
            return this;
        }

        /**
         * The ZIP code/Postal code of the location
         */
        public Builder zipCode(String zipCode) {
            Utils.checkNotNull(zipCode, "zipCode");
            this.zipCode = JsonNullable.of(zipCode);
            return this;
        }

        /**
         * The ZIP code/Postal code of the location
         */
        public Builder zipCode(JsonNullable<String> zipCode) {
            Utils.checkNotNull(zipCode, "zipCode");
            this.zipCode = zipCode;
            return this;
        }

        /**
         * The country code
         */
        public Builder country(HrisUpdateEmployeeRequestDtoHomeLocationCountry country) {
            Utils.checkNotNull(country, "country");
            this.country = JsonNullable.of(country);
            return this;
        }

        /**
         * The country code
         */
        public Builder country(JsonNullable<? extends HrisUpdateEmployeeRequestDtoHomeLocationCountry> country) {
            Utils.checkNotNull(country, "country");
            this.country = country;
            return this;
        }

        /**
         * Value to pass through to the provider
         */
        public Builder passthrough(Map<String, Object> passthrough) {
            Utils.checkNotNull(passthrough, "passthrough");
            this.passthrough = JsonNullable.of(passthrough);
            return this;
        }

        /**
         * Value to pass through to the provider
         */
        public Builder passthrough(JsonNullable<? extends Map<String, Object>> passthrough) {
            Utils.checkNotNull(passthrough, "passthrough");
            this.passthrough = passthrough;
            return this;
        }

        /**
         * The ISO3166-2 sub division where the location is situated
         */
        public Builder state(HrisUpdateEmployeeRequestDtoState state) {
            Utils.checkNotNull(state, "state");
            this.state = JsonNullable.of(state);
            return this;
        }

        /**
         * The ISO3166-2 sub division where the location is situated
         */
        public Builder state(JsonNullable<? extends HrisUpdateEmployeeRequestDtoState> state) {
            Utils.checkNotNull(state, "state");
            this.state = state;
            return this;
        }
        
        public HrisUpdateEmployeeRequestDtoHomeLocation build() {
            return new HrisUpdateEmployeeRequestDtoHomeLocation(
                id,
                name,
                phoneNumber,
                street1,
                street2,
                city,
                zipCode,
                country,
                passthrough,
                state);
        }
    }
}
