/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;

public class InterviewStatus {

    /**
     * The status of the interview.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends ScheduledInterviewValue> value;

    /**
     * The source value of the interview status.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends ScheduledInterviewSourceValue> sourceValue;

    @JsonCreator
    public InterviewStatus(
            @JsonProperty("value") JsonNullable<? extends ScheduledInterviewValue> value,
            @JsonProperty("source_value") JsonNullable<? extends ScheduledInterviewSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public InterviewStatus() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The status of the interview.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<ScheduledInterviewValue> value() {
        return (JsonNullable<ScheduledInterviewValue>) value;
    }

    /**
     * The source value of the interview status.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<ScheduledInterviewSourceValue> sourceValue() {
        return (JsonNullable<ScheduledInterviewSourceValue>) sourceValue;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The status of the interview.
     */
    public InterviewStatus withValue(ScheduledInterviewValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The status of the interview.
     */
    public InterviewStatus withValue(JsonNullable<? extends ScheduledInterviewValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    /**
     * The source value of the interview status.
     */
    public InterviewStatus withSourceValue(ScheduledInterviewSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    /**
     * The source value of the interview status.
     */
    public InterviewStatus withSourceValue(JsonNullable<? extends ScheduledInterviewSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        InterviewStatus other = (InterviewStatus) o;
        return 
            Utils.enhancedDeepEquals(this.value, other.value) &&
            Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            value,
            sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(InterviewStatus.class,
                "value", value,
                "sourceValue", sourceValue);
    }
    
    public final static class Builder {
 
        private JsonNullable<? extends ScheduledInterviewValue> value = JsonNullable.undefined();
 
        private JsonNullable<? extends ScheduledInterviewSourceValue> sourceValue = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The status of the interview.
         */
        public Builder value(ScheduledInterviewValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The status of the interview.
         */
        public Builder value(JsonNullable<? extends ScheduledInterviewValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        /**
         * The source value of the interview status.
         */
        public Builder sourceValue(ScheduledInterviewSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        /**
         * The source value of the interview status.
         */
        public Builder sourceValue(JsonNullable<? extends ScheduledInterviewSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }
        
        public InterviewStatus build() {
            return new InterviewStatus(
                value,
                sourceValue);
        }
    }
}
