/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * PayPeriod
 * 
 * <p>The pay period
 */
public class PayPeriod {

    /**
     * The pay period of the job postings.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends EmploymentValue> value;

    /**
     * The source value of the pay period.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends EmploymentSourceValue> sourceValue;

    @JsonCreator
    public PayPeriod(
            @JsonProperty("value") JsonNullable<? extends EmploymentValue> value,
            @JsonProperty("source_value") JsonNullable<? extends EmploymentSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public PayPeriod() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The pay period of the job postings.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<EmploymentValue> value() {
        return (JsonNullable<EmploymentValue>) value;
    }

    /**
     * The source value of the pay period.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<EmploymentSourceValue> sourceValue() {
        return (JsonNullable<EmploymentSourceValue>) sourceValue;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The pay period of the job postings.
     */
    public PayPeriod withValue(EmploymentValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The pay period of the job postings.
     */
    public PayPeriod withValue(JsonNullable<? extends EmploymentValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    /**
     * The source value of the pay period.
     */
    public PayPeriod withSourceValue(EmploymentSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    /**
     * The source value of the pay period.
     */
    public PayPeriod withSourceValue(JsonNullable<? extends EmploymentSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PayPeriod other = (PayPeriod) o;
        return 
            Utils.enhancedDeepEquals(this.value, other.value) &&
            Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            value,
            sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(PayPeriod.class,
                "value", value,
                "sourceValue", sourceValue);
    }
    
    public final static class Builder {
 
        private JsonNullable<? extends EmploymentValue> value = JsonNullable.undefined();
 
        private JsonNullable<? extends EmploymentSourceValue> sourceValue = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The pay period of the job postings.
         */
        public Builder value(EmploymentValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The pay period of the job postings.
         */
        public Builder value(JsonNullable<? extends EmploymentValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        /**
         * The source value of the pay period.
         */
        public Builder sourceValue(EmploymentSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        /**
         * The source value of the pay period.
         */
        public Builder sourceValue(JsonNullable<? extends EmploymentSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }
        
        public PayPeriod build() {
            return new PayPeriod(
                value,
                sourceValue);
        }
    }
}
