/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * PhoneNumberType
 * 
 * <p>Type of phone number
 */
@JsonDeserialize(using = PhoneNumberType._Deserializer.class)
@JsonSerialize(using = PhoneNumberType._Serializer.class)
public class PhoneNumberType {

    public static final PhoneNumberType PERSONAL = new PhoneNumberType("personal");
    public static final PhoneNumberType WORK = new PhoneNumberType("work");
    public static final PhoneNumberType MOBILE = new PhoneNumberType("mobile");
    public static final PhoneNumberType HOME = new PhoneNumberType("home");
    public static final PhoneNumberType UNKNOWN = new PhoneNumberType("unknown");
    public static final PhoneNumberType OTHER = new PhoneNumberType("other");
    public static final PhoneNumberType UNMAPPED_VALUE = new PhoneNumberType("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, PhoneNumberType> values = createValuesMap();
    private static final Map<String, PhoneNumberTypeEnum> enums = createEnumsMap();

    private final String value;

    private PhoneNumberType(String value) {
        this.value = value;
    }

    /**
     * Returns a PhoneNumberType with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as PhoneNumberType
     */ 
    public static PhoneNumberType of(String value) {
        synchronized (PhoneNumberType.class) {
            return values.computeIfAbsent(value, v -> new PhoneNumberType(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<PhoneNumberTypeEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        PhoneNumberType other = (PhoneNumberType) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "PhoneNumberType [value=" + value + "]";
    }

    // return an array just like an enum
    public static PhoneNumberType[] values() {
        synchronized (PhoneNumberType.class) {
            return values.values().toArray(new PhoneNumberType[] {});
        }
    }

    private static final Map<String, PhoneNumberType> createValuesMap() {
        Map<String, PhoneNumberType> map = new LinkedHashMap<>();
        map.put("personal", PERSONAL);
        map.put("work", WORK);
        map.put("mobile", MOBILE);
        map.put("home", HOME);
        map.put("unknown", UNKNOWN);
        map.put("other", OTHER);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, PhoneNumberTypeEnum> createEnumsMap() {
        Map<String, PhoneNumberTypeEnum> map = new HashMap<>();
        map.put("personal", PhoneNumberTypeEnum.PERSONAL);
        map.put("work", PhoneNumberTypeEnum.WORK);
        map.put("mobile", PhoneNumberTypeEnum.MOBILE);
        map.put("home", PhoneNumberTypeEnum.HOME);
        map.put("unknown", PhoneNumberTypeEnum.UNKNOWN);
        map.put("other", PhoneNumberTypeEnum.OTHER);
        map.put("unmapped_value", PhoneNumberTypeEnum.UNMAPPED_VALUE);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<PhoneNumberType> {

        protected _Serializer() {
            super(PhoneNumberType.class);
        }

        @Override
        public void serialize(PhoneNumberType value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<PhoneNumberType> {

        protected _Deserializer() {
            super(PhoneNumberType.class);
        }

        @Override
        public PhoneNumberType deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return PhoneNumberType.of(v);
        }
    }
    
    public enum PhoneNumberTypeEnum {

        PERSONAL("personal"),
        WORK("work"),
        MOBILE("mobile"),
        HOME("home"),
        UNKNOWN("unknown"),
        OTHER("other"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private PhoneNumberTypeEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

