/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Map;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * Request
 * 
 * <p>The advanced log request data
 */
public class Request {

    /**
     * The request ID
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * The request method
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("method")
    private JsonNullable<String> method;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("headers")
    private JsonNullable<? extends Map<String, Object>> headers;

    /**
     * The request URL data
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("url")
    private JsonNullable<? extends Url> url;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("body")
    private JsonNullable<? extends Object> body;

    @JsonCreator
    public Request(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("method") JsonNullable<String> method,
            @JsonProperty("headers") JsonNullable<? extends Map<String, Object>> headers,
            @JsonProperty("url") JsonNullable<? extends Url> url,
            @JsonProperty("body") JsonNullable<? extends Object> body) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(method, "method");
        Utils.checkNotNull(headers, "headers");
        Utils.checkNotNull(url, "url");
        Utils.checkNotNull(body, "body");
        this.id = id;
        this.method = method;
        this.headers = headers;
        this.url = url;
        this.body = body;
    }
    
    public Request() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The request ID
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * The request method
     */
    @JsonIgnore
    public JsonNullable<String> method() {
        return method;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> headers() {
        return (JsonNullable<Map<String, Object>>) headers;
    }

    /**
     * The request URL data
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Url> url() {
        return (JsonNullable<Url>) url;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Object> body() {
        return (JsonNullable<Object>) body;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The request ID
     */
    public Request withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * The request ID
     */
    public Request withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * The request method
     */
    public Request withMethod(String method) {
        Utils.checkNotNull(method, "method");
        this.method = JsonNullable.of(method);
        return this;
    }

    /**
     * The request method
     */
    public Request withMethod(JsonNullable<String> method) {
        Utils.checkNotNull(method, "method");
        this.method = method;
        return this;
    }

    public Request withHeaders(Map<String, Object> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = JsonNullable.of(headers);
        return this;
    }

    public Request withHeaders(JsonNullable<? extends Map<String, Object>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    /**
     * The request URL data
     */
    public Request withUrl(Url url) {
        Utils.checkNotNull(url, "url");
        this.url = JsonNullable.of(url);
        return this;
    }

    /**
     * The request URL data
     */
    public Request withUrl(JsonNullable<? extends Url> url) {
        Utils.checkNotNull(url, "url");
        this.url = url;
        return this;
    }

    public Request withBody(Object body) {
        Utils.checkNotNull(body, "body");
        this.body = JsonNullable.of(body);
        return this;
    }

    public Request withBody(JsonNullable<? extends Object> body) {
        Utils.checkNotNull(body, "body");
        this.body = body;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Request other = (Request) o;
        return 
            Utils.enhancedDeepEquals(this.id, other.id) &&
            Utils.enhancedDeepEquals(this.method, other.method) &&
            Utils.enhancedDeepEquals(this.headers, other.headers) &&
            Utils.enhancedDeepEquals(this.url, other.url) &&
            Utils.enhancedDeepEquals(this.body, other.body);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            id,
            method,
            headers,
            url,
            body);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Request.class,
                "id", id,
                "method", method,
                "headers", headers,
                "url", url,
                "body", body);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> id = JsonNullable.undefined();
 
        private JsonNullable<String> method = JsonNullable.undefined();
 
        private JsonNullable<? extends Map<String, Object>> headers = JsonNullable.undefined();
 
        private JsonNullable<? extends Url> url = JsonNullable.undefined();
 
        private JsonNullable<? extends Object> body = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The request ID
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * The request ID
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        /**
         * The request method
         */
        public Builder method(String method) {
            Utils.checkNotNull(method, "method");
            this.method = JsonNullable.of(method);
            return this;
        }

        /**
         * The request method
         */
        public Builder method(JsonNullable<String> method) {
            Utils.checkNotNull(method, "method");
            this.method = method;
            return this;
        }

        public Builder headers(Map<String, Object> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = JsonNullable.of(headers);
            return this;
        }

        public Builder headers(JsonNullable<? extends Map<String, Object>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        /**
         * The request URL data
         */
        public Builder url(Url url) {
            Utils.checkNotNull(url, "url");
            this.url = JsonNullable.of(url);
            return this;
        }

        /**
         * The request URL data
         */
        public Builder url(JsonNullable<? extends Url> url) {
            Utils.checkNotNull(url, "url");
            this.url = url;
            return this;
        }

        public Builder body(Object body) {
            Utils.checkNotNull(body, "body");
            this.body = JsonNullable.of(body);
            return this;
        }

        public Builder body(JsonNullable<? extends Object> body) {
            Utils.checkNotNull(body, "body");
            this.body = body;
            return this;
        }
        
        public Request build() {
            return new Request(
                id,
                method,
                headers,
                url,
                body);
        }
    }
}
