/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * UnifiedUploadRequestDtoCategory
 * 
 * <p>The category object for associating uploaded files. If both an ID and a name are provided, the ID takes precedence.
 */
public class UnifiedUploadRequestDtoCategory {

    /**
     * The category name for associating uploaded files.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<String> value;

    /**
     * The provider specific category for associating uploaded files, if provided, the value will be ignored.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<String> sourceValue;

    @JsonCreator
    public UnifiedUploadRequestDtoCategory(
            @JsonProperty("value") JsonNullable<String> value,
            @JsonProperty("source_value") JsonNullable<String> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public UnifiedUploadRequestDtoCategory() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The category name for associating uploaded files.
     */
    @JsonIgnore
    public JsonNullable<String> value() {
        return value;
    }

    /**
     * The provider specific category for associating uploaded files, if provided, the value will be ignored.
     */
    @JsonIgnore
    public JsonNullable<String> sourceValue() {
        return sourceValue;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * The category name for associating uploaded files.
     */
    public UnifiedUploadRequestDtoCategory withValue(String value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The category name for associating uploaded files.
     */
    public UnifiedUploadRequestDtoCategory withValue(JsonNullable<String> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    /**
     * The provider specific category for associating uploaded files, if provided, the value will be ignored.
     */
    public UnifiedUploadRequestDtoCategory withSourceValue(String sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    /**
     * The provider specific category for associating uploaded files, if provided, the value will be ignored.
     */
    public UnifiedUploadRequestDtoCategory withSourceValue(JsonNullable<String> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UnifiedUploadRequestDtoCategory other = (UnifiedUploadRequestDtoCategory) o;
        return 
            Utils.enhancedDeepEquals(this.value, other.value) &&
            Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            value,
            sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(UnifiedUploadRequestDtoCategory.class,
                "value", value,
                "sourceValue", sourceValue);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> value = JsonNullable.undefined();
 
        private JsonNullable<String> sourceValue = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The category name for associating uploaded files.
         */
        public Builder value(String value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The category name for associating uploaded files.
         */
        public Builder value(JsonNullable<String> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        /**
         * The provider specific category for associating uploaded files, if provided, the value will be ignored.
         */
        public Builder sourceValue(String sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        /**
         * The provider specific category for associating uploaded files, if provided, the value will be ignored.
         */
        public Builder sourceValue(JsonNullable<String> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }
        
        public UnifiedUploadRequestDtoCategory build() {
            return new UnifiedUploadRequestDtoCategory(
                value,
                sourceValue);
        }
    }
}
