/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.errors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Double;
import java.lang.Override;
import java.lang.RuntimeException;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;

@SuppressWarnings("serial")
public class NotFoundResponse extends RuntimeException {

    /**
     * HTTP status code
     */
    @JsonProperty("statusCode")
    private double statusCode;

    /**
     * Error message
     */
    @JsonProperty("message")
    private String message;

    /**
     * Timestamp when the error occurred
     */
    @JsonProperty("timestamp")
    private OffsetDateTime timestamp;

    @JsonCreator
    public NotFoundResponse(
            @JsonProperty("statusCode") double statusCode,
            @JsonProperty("message") String message,
            @JsonProperty("timestamp") OffsetDateTime timestamp) {
        super("API error occurred");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(message, "message");
        Utils.checkNotNull(timestamp, "timestamp");
        this.statusCode = statusCode;
        this.message = message;
        this.timestamp = timestamp;
    }

    /**
     * HTTP status code
     */
    @JsonIgnore
    public double statusCode() {
        return statusCode;
    }

    /**
     * Error message
     */
    @JsonIgnore
    public String message() {
        return message;
    }

    @JsonIgnore
    @Override
    public String getMessage() {
        return Utils.valueOrNull(message);
    }

    /**
     * Timestamp when the error occurred
     */
    @JsonIgnore
    public OffsetDateTime timestamp() {
        return timestamp;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * HTTP status code
     */
    public NotFoundResponse withStatusCode(double statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    /**
     * Error message
     */
    public NotFoundResponse withMessage(String message) {
        Utils.checkNotNull(message, "message");
        this.message = message;
        return this;
    }

    /**
     * Timestamp when the error occurred
     */
    public NotFoundResponse withTimestamp(OffsetDateTime timestamp) {
        Utils.checkNotNull(timestamp, "timestamp");
        this.timestamp = timestamp;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        NotFoundResponse other = (NotFoundResponse) o;
        return 
            Utils.enhancedDeepEquals(this.statusCode, other.statusCode) &&
            Utils.enhancedDeepEquals(this.message, other.message) &&
            Utils.enhancedDeepEquals(this.timestamp, other.timestamp);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            statusCode,
            message,
            timestamp);
    }
    
    @Override
    public String toString() {
        return Utils.toString(NotFoundResponse.class,
                "statusCode", statusCode,
                "message", message,
                "timestamp", timestamp);
    }
    
    public final static class Builder {
 
        private Double statusCode;
 
        private String message;
 
        private OffsetDateTime timestamp;
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * HTTP status code
         */
        public Builder statusCode(double statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        /**
         * Error message
         */
        public Builder message(String message) {
            Utils.checkNotNull(message, "message");
            this.message = message;
            return this;
        }

        /**
         * Timestamp when the error occurred
         */
        public Builder timestamp(OffsetDateTime timestamp) {
            Utils.checkNotNull(timestamp, "timestamp");
            this.timestamp = timestamp;
            return this;
        }
        
        public NotFoundResponse build() {
            return new NotFoundResponse(
                statusCode,
                message,
                timestamp);
        }
    }
}

