/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.TimeOffPolicyResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HrisGetTimeOffPolicyResponse implements Response {

    /**
     * HTTP response content type for this operation
     */
    private String contentType;

    /**
     * HTTP response status code for this operation
     */
    private int statusCode;

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    private HttpResponse<InputStream> rawResponse;

    /**
     * The time off policy with the given identifier was retrieved.
     */
    private Optional<? extends TimeOffPolicyResult> timeOffPolicyResult;

    private Map<String, List<String>> headers;

    @JsonCreator
    public HrisGetTimeOffPolicyResponse(
            String contentType,
            int statusCode,
            HttpResponse<InputStream> rawResponse,
            Optional<? extends TimeOffPolicyResult> timeOffPolicyResult,
            Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(timeOffPolicyResult, "timeOffPolicyResult");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.timeOffPolicyResult = timeOffPolicyResult;
        this.headers = headers;
    }
    
    public HrisGetTimeOffPolicyResponse(
            String contentType,
            int statusCode,
            HttpResponse<InputStream> rawResponse,
            Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    /**
     * HTTP response content type for this operation
     */
    @JsonIgnore
    public String contentType() {
        return contentType;
    }

    /**
     * HTTP response status code for this operation
     */
    @JsonIgnore
    public int statusCode() {
        return statusCode;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return rawResponse;
    }

    /**
     * The time off policy with the given identifier was retrieved.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<TimeOffPolicyResult> timeOffPolicyResult() {
        return (Optional<TimeOffPolicyResult>) timeOffPolicyResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return headers;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * HTTP response content type for this operation
     */
    public HrisGetTimeOffPolicyResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    /**
     * HTTP response status code for this operation
     */
    public HrisGetTimeOffPolicyResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    public HrisGetTimeOffPolicyResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    /**
     * The time off policy with the given identifier was retrieved.
     */
    public HrisGetTimeOffPolicyResponse withTimeOffPolicyResult(TimeOffPolicyResult timeOffPolicyResult) {
        Utils.checkNotNull(timeOffPolicyResult, "timeOffPolicyResult");
        this.timeOffPolicyResult = Optional.ofNullable(timeOffPolicyResult);
        return this;
    }

    /**
     * The time off policy with the given identifier was retrieved.
     */
    public HrisGetTimeOffPolicyResponse withTimeOffPolicyResult(Optional<? extends TimeOffPolicyResult> timeOffPolicyResult) {
        Utils.checkNotNull(timeOffPolicyResult, "timeOffPolicyResult");
        this.timeOffPolicyResult = timeOffPolicyResult;
        return this;
    }

    public HrisGetTimeOffPolicyResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        HrisGetTimeOffPolicyResponse other = (HrisGetTimeOffPolicyResponse) o;
        return 
            Utils.enhancedDeepEquals(this.contentType, other.contentType) &&
            Utils.enhancedDeepEquals(this.statusCode, other.statusCode) &&
            Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) &&
            Utils.enhancedDeepEquals(this.timeOffPolicyResult, other.timeOffPolicyResult) &&
            Utils.enhancedDeepEquals(this.headers, other.headers);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            contentType,
            statusCode,
            rawResponse,
            timeOffPolicyResult,
            headers);
    }
    
    @Override
    public String toString() {
        return Utils.toString(HrisGetTimeOffPolicyResponse.class,
                "contentType", contentType,
                "statusCode", statusCode,
                "rawResponse", rawResponse,
                "timeOffPolicyResult", timeOffPolicyResult,
                "headers", headers);
    }
    
    public final static class Builder {
 
        private String contentType;
 
        private Integer statusCode;
 
        private HttpResponse<InputStream> rawResponse;
 
        private Optional<? extends TimeOffPolicyResult> timeOffPolicyResult = Optional.empty();
 
        private Map<String, List<String>> headers;
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * HTTP response content type for this operation
         */
        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        /**
         * HTTP response status code for this operation
         */
        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        /**
         * Raw HTTP response; suitable for custom response parsing
         */
        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        /**
         * The time off policy with the given identifier was retrieved.
         */
        public Builder timeOffPolicyResult(TimeOffPolicyResult timeOffPolicyResult) {
            Utils.checkNotNull(timeOffPolicyResult, "timeOffPolicyResult");
            this.timeOffPolicyResult = Optional.ofNullable(timeOffPolicyResult);
            return this;
        }

        /**
         * The time off policy with the given identifier was retrieved.
         */
        public Builder timeOffPolicyResult(Optional<? extends TimeOffPolicyResult> timeOffPolicyResult) {
            Utils.checkNotNull(timeOffPolicyResult, "timeOffPolicyResult");
            this.timeOffPolicyResult = timeOffPolicyResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }
        
        public HrisGetTimeOffPolicyResponse build() {
            return new HrisGetTimeOffPolicyResponse(
                contentType,
                statusCode,
                rawResponse,
                timeOffPolicyResult,
                headers);
        }
    }
}
