/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.utils.SpeakeasyMetadata;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * HrisListTimeOffRequestsQueryParamFilter
 * 
 * <p>HRIS Time Off filters
 */
public class HrisListTimeOffRequestsQueryParamFilter {

    /**
     * Use a string with a date to only select results updated after that given date
     */
    @SpeakeasyMetadata("queryParam:name=updated_after")
    private JsonNullable<String> updatedAfter;

    /**
     * List of time off type ids to filter by.
     */
    @SpeakeasyMetadata("queryParam:name=type_ids")
    private JsonNullable<? extends List<String>> typeIds;

    @JsonCreator
    public HrisListTimeOffRequestsQueryParamFilter(
            JsonNullable<String> updatedAfter,
            JsonNullable<? extends List<String>> typeIds) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        Utils.checkNotNull(typeIds, "typeIds");
        this.updatedAfter = updatedAfter;
        this.typeIds = typeIds;
    }
    
    public HrisListTimeOffRequestsQueryParamFilter() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Use a string with a date to only select results updated after that given date
     */
    @JsonIgnore
    public JsonNullable<String> updatedAfter() {
        return updatedAfter;
    }

    /**
     * List of time off type ids to filter by.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<String>> typeIds() {
        return (JsonNullable<List<String>>) typeIds;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * Use a string with a date to only select results updated after that given date
     */
    public HrisListTimeOffRequestsQueryParamFilter withUpdatedAfter(String updatedAfter) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        this.updatedAfter = JsonNullable.of(updatedAfter);
        return this;
    }

    /**
     * Use a string with a date to only select results updated after that given date
     */
    public HrisListTimeOffRequestsQueryParamFilter withUpdatedAfter(JsonNullable<String> updatedAfter) {
        Utils.checkNotNull(updatedAfter, "updatedAfter");
        this.updatedAfter = updatedAfter;
        return this;
    }

    /**
     * List of time off type ids to filter by.
     */
    public HrisListTimeOffRequestsQueryParamFilter withTypeIds(List<String> typeIds) {
        Utils.checkNotNull(typeIds, "typeIds");
        this.typeIds = JsonNullable.of(typeIds);
        return this;
    }

    /**
     * List of time off type ids to filter by.
     */
    public HrisListTimeOffRequestsQueryParamFilter withTypeIds(JsonNullable<? extends List<String>> typeIds) {
        Utils.checkNotNull(typeIds, "typeIds");
        this.typeIds = typeIds;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        HrisListTimeOffRequestsQueryParamFilter other = (HrisListTimeOffRequestsQueryParamFilter) o;
        return 
            Utils.enhancedDeepEquals(this.updatedAfter, other.updatedAfter) &&
            Utils.enhancedDeepEquals(this.typeIds, other.typeIds);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            updatedAfter,
            typeIds);
    }
    
    @Override
    public String toString() {
        return Utils.toString(HrisListTimeOffRequestsQueryParamFilter.class,
                "updatedAfter", updatedAfter,
                "typeIds", typeIds);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> updatedAfter = JsonNullable.undefined();
 
        private JsonNullable<? extends List<String>> typeIds = JsonNullable.undefined();
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Use a string with a date to only select results updated after that given date
         */
        public Builder updatedAfter(String updatedAfter) {
            Utils.checkNotNull(updatedAfter, "updatedAfter");
            this.updatedAfter = JsonNullable.of(updatedAfter);
            return this;
        }

        /**
         * Use a string with a date to only select results updated after that given date
         */
        public Builder updatedAfter(JsonNullable<String> updatedAfter) {
            Utils.checkNotNull(updatedAfter, "updatedAfter");
            this.updatedAfter = updatedAfter;
            return this;
        }

        /**
         * List of time off type ids to filter by.
         */
        public Builder typeIds(List<String> typeIds) {
            Utils.checkNotNull(typeIds, "typeIds");
            this.typeIds = JsonNullable.of(typeIds);
            return this;
        }

        /**
         * List of time off type ids to filter by.
         */
        public Builder typeIds(JsonNullable<? extends List<String>> typeIds) {
            Utils.checkNotNull(typeIds, "typeIds");
            this.typeIds = typeIds;
            return this;
        }
        
        public HrisListTimeOffRequestsQueryParamFilter build() {
            return new HrisListTimeOffRequestsQueryParamFilter(
                updatedAfter,
                typeIds);
        }
    }
}
