/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.PushTemplatesPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.lang.Integer;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MarketingListPushTemplatesResponse implements Response {

    /**
     * HTTP response content type for this operation
     */
    private String contentType;

    /**
     * HTTP response status code for this operation
     */
    private int statusCode;

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    private HttpResponse<InputStream> rawResponse;

    /**
     * The list of push templates was retrieved.
     */
    private Optional<? extends PushTemplatesPaginated> pushTemplatesPaginated;

    private Map<String, List<String>> headers;

    @JsonCreator
    public MarketingListPushTemplatesResponse(
            String contentType,
            int statusCode,
            HttpResponse<InputStream> rawResponse,
            Optional<? extends PushTemplatesPaginated> pushTemplatesPaginated,
            Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(pushTemplatesPaginated, "pushTemplatesPaginated");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.pushTemplatesPaginated = pushTemplatesPaginated;
        this.headers = headers;
    }
    
    public MarketingListPushTemplatesResponse(
            String contentType,
            int statusCode,
            HttpResponse<InputStream> rawResponse,
            Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    /**
     * HTTP response content type for this operation
     */
    @JsonIgnore
    public String contentType() {
        return contentType;
    }

    /**
     * HTTP response status code for this operation
     */
    @JsonIgnore
    public int statusCode() {
        return statusCode;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return rawResponse;
    }

    /**
     * The list of push templates was retrieved.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public Optional<PushTemplatesPaginated> pushTemplatesPaginated() {
        return (Optional<PushTemplatesPaginated>) pushTemplatesPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return headers;
    }

    public final static Builder builder() {
        return new Builder();
    }    

    /**
     * HTTP response content type for this operation
     */
    public MarketingListPushTemplatesResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    /**
     * HTTP response status code for this operation
     */
    public MarketingListPushTemplatesResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    /**
     * Raw HTTP response; suitable for custom response parsing
     */
    public MarketingListPushTemplatesResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    /**
     * The list of push templates was retrieved.
     */
    public MarketingListPushTemplatesResponse withPushTemplatesPaginated(PushTemplatesPaginated pushTemplatesPaginated) {
        Utils.checkNotNull(pushTemplatesPaginated, "pushTemplatesPaginated");
        this.pushTemplatesPaginated = Optional.ofNullable(pushTemplatesPaginated);
        return this;
    }

    /**
     * The list of push templates was retrieved.
     */
    public MarketingListPushTemplatesResponse withPushTemplatesPaginated(Optional<? extends PushTemplatesPaginated> pushTemplatesPaginated) {
        Utils.checkNotNull(pushTemplatesPaginated, "pushTemplatesPaginated");
        this.pushTemplatesPaginated = pushTemplatesPaginated;
        return this;
    }

    public MarketingListPushTemplatesResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        MarketingListPushTemplatesResponse other = (MarketingListPushTemplatesResponse) o;
        return 
            Utils.enhancedDeepEquals(this.contentType, other.contentType) &&
            Utils.enhancedDeepEquals(this.statusCode, other.statusCode) &&
            Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) &&
            Utils.enhancedDeepEquals(this.pushTemplatesPaginated, other.pushTemplatesPaginated) &&
            Utils.enhancedDeepEquals(this.headers, other.headers);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            contentType,
            statusCode,
            rawResponse,
            pushTemplatesPaginated,
            headers);
    }
    
    @Override
    public String toString() {
        return Utils.toString(MarketingListPushTemplatesResponse.class,
                "contentType", contentType,
                "statusCode", statusCode,
                "rawResponse", rawResponse,
                "pushTemplatesPaginated", pushTemplatesPaginated,
                "headers", headers);
    }
    
    public final static class Builder {
 
        private String contentType;
 
        private Integer statusCode;
 
        private HttpResponse<InputStream> rawResponse;
 
        private Optional<? extends PushTemplatesPaginated> pushTemplatesPaginated = Optional.empty();
 
        private Map<String, List<String>> headers;
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * HTTP response content type for this operation
         */
        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        /**
         * HTTP response status code for this operation
         */
        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        /**
         * Raw HTTP response; suitable for custom response parsing
         */
        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        /**
         * The list of push templates was retrieved.
         */
        public Builder pushTemplatesPaginated(PushTemplatesPaginated pushTemplatesPaginated) {
            Utils.checkNotNull(pushTemplatesPaginated, "pushTemplatesPaginated");
            this.pushTemplatesPaginated = Optional.ofNullable(pushTemplatesPaginated);
            return this;
        }

        /**
         * The list of push templates was retrieved.
         */
        public Builder pushTemplatesPaginated(Optional<? extends PushTemplatesPaginated> pushTemplatesPaginated) {
            Utils.checkNotNull(pushTemplatesPaginated, "pushTemplatesPaginated");
            this.pushTemplatesPaginated = pushTemplatesPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }
        
        public MarketingListPushTemplatesResponse build() {
            return new MarketingListPushTemplatesResponse(
                contentType,
                statusCode,
                rawResponse,
                pushTemplatesPaginated,
                headers);
        }
    }
}
