/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.ApplicationSourceValue;
import com.stackone.stackone_client_java.models.components.ApplicationValue;
import com.stackone.stackone_client_java.utils.Utils;
import org.openapitools.jackson.nullable.JsonNullable;

public class ApplicationStatus {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="value")
    private JsonNullable<? extends ApplicationValue> value;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="source_value")
    private JsonNullable<? extends ApplicationSourceValue> sourceValue;

    @JsonCreator
    public ApplicationStatus(@JsonProperty(value="value") JsonNullable<? extends ApplicationValue> value, @JsonProperty(value="source_value") JsonNullable<? extends ApplicationSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }

    public ApplicationStatus() {
        this((JsonNullable<? extends ApplicationValue>)JsonNullable.undefined(), (JsonNullable<? extends ApplicationSourceValue>)JsonNullable.undefined());
    }

    @JsonIgnore
    public JsonNullable<ApplicationValue> value() {
        return this.value;
    }

    @JsonIgnore
    public JsonNullable<ApplicationSourceValue> sourceValue() {
        return this.sourceValue;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public ApplicationStatus withValue(ApplicationValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of((Object)value);
        return this;
    }

    public ApplicationStatus withValue(JsonNullable<? extends ApplicationValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public ApplicationStatus withSourceValue(ApplicationSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of((Object)sourceValue);
        return this;
    }

    public ApplicationStatus withSourceValue(JsonNullable<? extends ApplicationSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationStatus other = (ApplicationStatus)o;
        return Utils.enhancedDeepEquals(this.value, other.value) && Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.value, this.sourceValue);
    }

    public String toString() {
        return Utils.toString(ApplicationStatus.class, "value", this.value, "sourceValue", this.sourceValue);
    }

    public static final class Builder {
        private JsonNullable<? extends ApplicationValue> value = JsonNullable.undefined();
        private JsonNullable<? extends ApplicationSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
        }

        public Builder value(ApplicationValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of((Object)value);
            return this;
        }

        public Builder value(JsonNullable<? extends ApplicationValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public Builder sourceValue(ApplicationSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of((Object)sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends ApplicationSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public ApplicationStatus build() {
            return new ApplicationStatus(this.value, this.sourceValue);
        }
    }
}

