/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.HRISBenefitsPaginated;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HrisListBenefitsResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends HRISBenefitsPaginated> hrisBenefitsPaginated;
    private Map<String, List<String>> headers;

    @JsonCreator
    public HrisListBenefitsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends HRISBenefitsPaginated> hrisBenefitsPaginated, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(hrisBenefitsPaginated, "hrisBenefitsPaginated");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.hrisBenefitsPaginated = hrisBenefitsPaginated;
        this.headers = headers;
    }

    public HrisListBenefitsResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<HRISBenefitsPaginated> hrisBenefitsPaginated() {
        return this.hrisBenefitsPaginated;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public HrisListBenefitsResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public HrisListBenefitsResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public HrisListBenefitsResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public HrisListBenefitsResponse withHRISBenefitsPaginated(HRISBenefitsPaginated hrisBenefitsPaginated) {
        Utils.checkNotNull(hrisBenefitsPaginated, "hrisBenefitsPaginated");
        this.hrisBenefitsPaginated = Optional.ofNullable(hrisBenefitsPaginated);
        return this;
    }

    public HrisListBenefitsResponse withHRISBenefitsPaginated(Optional<? extends HRISBenefitsPaginated> hrisBenefitsPaginated) {
        Utils.checkNotNull(hrisBenefitsPaginated, "hrisBenefitsPaginated");
        this.hrisBenefitsPaginated = hrisBenefitsPaginated;
        return this;
    }

    public HrisListBenefitsResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisListBenefitsResponse other = (HrisListBenefitsResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.hrisBenefitsPaginated, other.hrisBenefitsPaginated) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.hrisBenefitsPaginated, this.headers);
    }

    public String toString() {
        return Utils.toString(HrisListBenefitsResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "hrisBenefitsPaginated", this.hrisBenefitsPaginated, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends HRISBenefitsPaginated> hrisBenefitsPaginated = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder hrisBenefitsPaginated(HRISBenefitsPaginated hrisBenefitsPaginated) {
            Utils.checkNotNull(hrisBenefitsPaginated, "hrisBenefitsPaginated");
            this.hrisBenefitsPaginated = Optional.ofNullable(hrisBenefitsPaginated);
            return this;
        }

        public Builder hrisBenefitsPaginated(Optional<? extends HRISBenefitsPaginated> hrisBenefitsPaginated) {
            Utils.checkNotNull(hrisBenefitsPaginated, "hrisBenefitsPaginated");
            this.hrisBenefitsPaginated = hrisBenefitsPaginated;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public HrisListBenefitsResponse build() {
            return new HrisListBenefitsResponse(this.contentType, this.statusCode, this.rawResponse, this.hrisBenefitsPaginated, this.headers);
        }
    }
}

