/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.operations;

import com.fasterxml.jackson.core.type.TypeReference;
import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.SecuritySource;
import com.stackone.stackone_client_java.models.components.CreateResult;
import com.stackone.stackone_client_java.models.errors.BadGatewayResponse;
import com.stackone.stackone_client_java.models.errors.BadRequestResponse;
import com.stackone.stackone_client_java.models.errors.ConflictResponse;
import com.stackone.stackone_client_java.models.errors.ForbiddenResponse;
import com.stackone.stackone_client_java.models.errors.InternalServerErrorResponse;
import com.stackone.stackone_client_java.models.errors.NotFoundResponse;
import com.stackone.stackone_client_java.models.errors.NotImplementedResponse;
import com.stackone.stackone_client_java.models.errors.PreconditionFailedResponse;
import com.stackone.stackone_client_java.models.errors.RequestTimedOutResponse;
import com.stackone.stackone_client_java.models.errors.SDKError;
import com.stackone.stackone_client_java.models.errors.TooManyRequestsResponse;
import com.stackone.stackone_client_java.models.errors.UnauthorizedResponse;
import com.stackone.stackone_client_java.models.errors.UnprocessableEntityResponse;
import com.stackone.stackone_client_java.models.operations.HrisCreateEmployeeTimeOffRequestRequest;
import com.stackone.stackone_client_java.models.operations.HrisCreateEmployeeTimeOffRequestResponse;
import com.stackone.stackone_client_java.operations.Operations;
import com.stackone.stackone_client_java.utils.BackoffStrategy;
import com.stackone.stackone_client_java.utils.HTTPClient;
import com.stackone.stackone_client_java.utils.HTTPRequest;
import com.stackone.stackone_client_java.utils.Hook;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.Retries;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.SerializedBody;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class HrisCreateEmployeeTimeOffRequestOperation
implements Operations.RequestOperation<HrisCreateEmployeeTimeOffRequestRequest, HrisCreateEmployeeTimeOffRequestResponse> {
    private final SDKConfiguration sdkConfiguration;
    private final Optional<Options> options;

    public HrisCreateEmployeeTimeOffRequestOperation(SDKConfiguration sdkConfiguration, Optional<Options> options) {
        this.sdkConfiguration = sdkConfiguration;
        this.options = options;
    }

    @Override
    public HttpResponse<InputStream> doRequest(HrisCreateEmployeeTimeOffRequestRequest request) throws Exception {
        this.options.ifPresent(o -> o.validate(List.of(Options.Option.RETRY_CONFIG)));
        String baseUrl = this.sdkConfiguration.serverUrl();
        String url = Utils.generateURL(HrisCreateEmployeeTimeOffRequestRequest.class, baseUrl, "/unified/hris/employees/{id}/time_off", request, null);
        HTTPRequest req = new HTTPRequest(url, "POST");
        Object convertedRequest = Utils.convertToShape(request, Utils.JsonShape.DEFAULT, new TypeReference<Object>(){});
        SerializedBody serializedRequestBody = Utils.serializeRequestBody(convertedRequest, "hrisCreateTimeOffRequestDto", "json", false);
        if (serializedRequestBody == null) {
            throw new Exception("Request body is required");
        }
        req.setBody(Optional.ofNullable(serializedRequestBody));
        req.addHeader("Accept", "application/json").addHeader("user-agent", SDKConfiguration.USER_AGENT);
        req.addHeaders(Utils.getHeadersFromMetadata(request, null));
        Optional<SecuritySource> hookSecuritySource = Optional.of(this.sdkConfiguration.securitySource());
        Utils.configureSecurity(req, this.sdkConfiguration.securitySource().getSecurity());
        HTTPClient client = this.sdkConfiguration.client();
        HTTPRequest finalReq = req;
        RetryConfig retryConfig = this.options.flatMap(Options::retryConfig).or(this.sdkConfiguration::retryConfig).orElse(RetryConfig.builder().backoff(BackoffStrategy.builder().initialInterval(500L, TimeUnit.MILLISECONDS).maxInterval(60000L, TimeUnit.MILLISECONDS).baseFactor(1.5).maxElapsedTime(3600000L, TimeUnit.MILLISECONDS).retryConnectError(true).build()).build());
        ArrayList<String> statusCodes = new ArrayList<String>();
        statusCodes.add("429");
        statusCodes.add("408");
        Retries retries = Retries.builder().action(() -> {
            HttpRequest r = null;
            try {
                r = this.sdkConfiguration.hooks().beforeRequest(new Hook.BeforeRequestContextImpl(this.sdkConfiguration, baseUrl, "hris_create_employee_time_off_request", Optional.of(List.of()), hookSecuritySource), finalReq.build());
            }
            catch (Exception e) {
                throw new Retries.NonRetryableException(e);
            }
            try {
                return client.send(r);
            }
            catch (Exception e) {
                return this.sdkConfiguration.hooks().afterError(new Hook.AfterErrorContextImpl(this.sdkConfiguration, baseUrl, "hris_create_employee_time_off_request", Optional.of(List.of()), hookSecuritySource), Optional.empty(), Optional.of(e));
            }
        }).retryConfig(retryConfig).statusCodes(statusCodes).build();
        HttpResponse<InputStream> httpRes = this.sdkConfiguration.hooks().afterSuccess(new Hook.AfterSuccessContextImpl(this.sdkConfiguration, baseUrl, "hris_create_employee_time_off_request", Optional.of(List.of()), hookSecuritySource), retries.run());
        return httpRes;
    }

    @Override
    public HrisCreateEmployeeTimeOffRequestResponse handleResponse(HttpResponse<InputStream> response) throws Exception {
        String contentType = response.headers().firstValue("Content-Type").orElse("application/octet-stream");
        HrisCreateEmployeeTimeOffRequestResponse.Builder resBuilder = HrisCreateEmployeeTimeOffRequestResponse.builder().contentType(contentType).statusCode(response.statusCode()).rawResponse(response);
        HrisCreateEmployeeTimeOffRequestResponse res = resBuilder.build();
        if (Utils.statusCodeMatches(response.statusCode(), "201")) {
            if (Utils.contentTypeMatches(contentType, "application/json")) {
                CreateResult out = (CreateResult)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<CreateResult>(){});
                res.withCreateResult(out);
                return res;
            }
            throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
        }
        if (Utils.statusCodeMatches(response.statusCode(), "400")) {
            if (Utils.contentTypeMatches(contentType, "application/json")) {
                BadRequestResponse out = (BadRequestResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<BadRequestResponse>(){});
                throw out;
            }
            throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
        }
        if (Utils.statusCodeMatches(response.statusCode(), "401")) {
            if (Utils.contentTypeMatches(contentType, "application/json")) {
                UnauthorizedResponse out = (UnauthorizedResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<UnauthorizedResponse>(){});
                throw out;
            }
            throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
        }
        if (Utils.statusCodeMatches(response.statusCode(), "403")) {
            if (Utils.contentTypeMatches(contentType, "application/json")) {
                ForbiddenResponse out = (ForbiddenResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<ForbiddenResponse>(){});
                throw out;
            }
            throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
        }
        if (Utils.statusCodeMatches(response.statusCode(), "404")) {
            if (Utils.contentTypeMatches(contentType, "application/json")) {
                NotFoundResponse out = (NotFoundResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<NotFoundResponse>(){});
                throw out;
            }
            throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
        }
        if (Utils.statusCodeMatches(response.statusCode(), "408")) {
            res.withHeaders(response.headers().map());
            if (Utils.contentTypeMatches(contentType, "application/json")) {
                RequestTimedOutResponse out = (RequestTimedOutResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<RequestTimedOutResponse>(){});
                throw out;
            }
            throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
        }
        if (Utils.statusCodeMatches(response.statusCode(), "409")) {
            if (Utils.contentTypeMatches(contentType, "application/json")) {
                ConflictResponse out = (ConflictResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<ConflictResponse>(){});
                throw out;
            }
            throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
        }
        if (Utils.statusCodeMatches(response.statusCode(), "412")) {
            if (Utils.contentTypeMatches(contentType, "application/json")) {
                PreconditionFailedResponse out = (PreconditionFailedResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<PreconditionFailedResponse>(){});
                throw out;
            }
            throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
        }
        if (Utils.statusCodeMatches(response.statusCode(), "422")) {
            if (Utils.contentTypeMatches(contentType, "application/json")) {
                UnprocessableEntityResponse out = (UnprocessableEntityResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<UnprocessableEntityResponse>(){});
                throw out;
            }
            throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
        }
        if (Utils.statusCodeMatches(response.statusCode(), "429")) {
            if (Utils.contentTypeMatches(contentType, "application/json")) {
                TooManyRequestsResponse out = (TooManyRequestsResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<TooManyRequestsResponse>(){});
                throw out;
            }
            throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
        }
        if (Utils.statusCodeMatches(response.statusCode(), "500")) {
            if (Utils.contentTypeMatches(contentType, "application/json")) {
                InternalServerErrorResponse out = (InternalServerErrorResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<InternalServerErrorResponse>(){});
                throw out;
            }
            throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
        }
        if (Utils.statusCodeMatches(response.statusCode(), "501")) {
            if (Utils.contentTypeMatches(contentType, "application/json")) {
                NotImplementedResponse out = (NotImplementedResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<NotImplementedResponse>(){});
                throw out;
            }
            throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
        }
        if (Utils.statusCodeMatches(response.statusCode(), "502")) {
            if (Utils.contentTypeMatches(contentType, "application/json")) {
                BadGatewayResponse out = (BadGatewayResponse)Utils.mapper().readValue(response.body(), (TypeReference)new TypeReference<BadGatewayResponse>(){});
                throw out;
            }
            throw new SDKError(response, response.statusCode(), "Unexpected content-type received: " + contentType, Utils.extractByteArrayFromBody(response));
        }
        if (Utils.statusCodeMatches(response.statusCode(), "4XX")) {
            throw new SDKError(response, response.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(response));
        }
        if (Utils.statusCodeMatches(response.statusCode(), "5XX")) {
            throw new SDKError(response, response.statusCode(), "API error occurred", Utils.extractByteArrayFromBody(response));
        }
        throw new SDKError(response, response.statusCode(), "Unexpected status code received: " + response.statusCode(), Utils.extractByteArrayFromBody(response));
    }
}

