/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloudapi.common.provider;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.tencentcloudapi.common.CommonClient;
import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import com.tencentcloudapi.common.profile.ClientProfile;
import com.tencentcloudapi.common.profile.HttpProfile;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class STSCredential
extends Credential {
    private String secretId;
    private String secretKey;
    private String roleArn;
    private String roleSessionName;
    private String tmpSecretId;
    private String tmpSecretKey;
    private String token;
    private int expiredTime;

    public STSCredential(String secretId, String secretKey, String roleArn, String roleSessionName) {
        this.secretId = secretId;
        this.secretKey = secretKey;
        this.roleArn = roleArn;
        this.roleSessionName = roleSessionName;
    }

    @Override
    public String getSecretId() {
        if (this.tmpSecretId == null || this.needRefresh()) {
            try {
                this.updateCredential();
            }
            catch (TencentCloudSDKException e) {
                return null;
            }
        }
        return this.tmpSecretId;
    }

    @Override
    public String getSecretKey() {
        if (this.tmpSecretKey == null || this.needRefresh()) {
            try {
                this.updateCredential();
            }
            catch (TencentCloudSDKException e) {
                return null;
            }
        }
        return this.tmpSecretKey;
    }

    @Override
    public String getToken() {
        if (this.token == null || this.needRefresh()) {
            try {
                this.updateCredential();
            }
            catch (TencentCloudSDKException e) {
                return null;
            }
        }
        return this.token;
    }

    private void updateCredential() throws TencentCloudSDKException {
        Credential cred = new Credential(this.secretId, this.secretKey);
        HttpProfile httpProfile = new HttpProfile();
        httpProfile.setEndpoint("sts.tencentcloudapi.com");
        ClientProfile clientProfile = new ClientProfile();
        clientProfile.setHttpProfile(httpProfile);
        CommonClient client = new CommonClient("sts", "2018-08-13", cred, "ap-guangzhou", clientProfile);
        String resp = client.call("AssumeRole", "{\"RoleArn\":\"" + this.roleArn + "\",\"RoleSessionName\":\"" + this.roleSessionName + "\"}");
        Map map = (Map)new Gson().fromJson(resp, new TypeToken<HashMap<String, Object>>(){}.getType());
        Map respmap = (Map)map.get("Response");
        Map credmap = (Map)respmap.get("Credentials");
        this.tmpSecretId = (String)credmap.get("TmpSecretId");
        this.tmpSecretKey = (String)credmap.get("TmpSecretKey");
        this.token = (String)credmap.get("Token");
        this.expiredTime = ((Double)respmap.get("ExpiredTime")).intValue();
    }

    private boolean needRefresh() {
        return (long)this.expiredTime - new Date().getTime() / 1000L <= 300L;
    }
}

