/*
 * Decompiled with CFR 0.152.
 */
package com.vortexsoftware.sdk.spring;

import com.vortexsoftware.sdk.VortexClient;
import com.vortexsoftware.sdk.VortexException;
import com.vortexsoftware.sdk.spring.VortexConfig;
import com.vortexsoftware.sdk.types.AcceptInvitationRequest;
import com.vortexsoftware.sdk.types.InvitationResult;
import com.vortexsoftware.sdk.types.User;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/vortex"})
public class VortexController {
    private static final Logger logger = LoggerFactory.getLogger(VortexController.class);
    private final VortexClient vortexClient;
    private final VortexConfig config;

    public VortexController(VortexClient vortexClient, VortexConfig config) {
        this.vortexClient = vortexClient;
        this.config = config;
    }

    @PostMapping(value={"/jwt"})
    public ResponseEntity<?> generateJWT() {
        try {
            VortexConfig.VortexUser user = this.config.authenticateUser();
            if (user == null) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body(Map.of("error", "Authentication required"));
            }
            if (!this.config.authorizeOperation("JWT", user)) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body(Map.of("error", "Not authorized to generate JWT"));
            }
            List<String> adminScopes = null;
            if (user.getUserIsAutoJoinAdmin() != null && user.getUserIsAutoJoinAdmin().booleanValue()) {
                adminScopes = List.of("autoJoin");
            }
            User vortexUser = new User(user.getUserId(), user.getUserEmail(), adminScopes);
            logger.debug("Generating JWT for user {}", (Object)user.getUserId());
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("user", vortexUser);
            String jwt = this.vortexClient.generateJwt(params);
            return ResponseEntity.ok(Map.of("jwt", jwt));
        }
        catch (VortexException e) {
            logger.error("Failed to generate JWT", (Throwable)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Map.of("error", "Failed to generate JWT"));
        }
    }

    @GetMapping(value={"/invitations"})
    public ResponseEntity<?> getInvitationsByTarget(@RequestParam(value="targetType") String targetType, @RequestParam(value="targetValue") String targetValue) {
        try {
            VortexConfig.VortexUser user = this.config.authenticateUser();
            if (user == null) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body(Map.of("error", "Authentication required"));
            }
            if (!this.config.authorizeOperation("GET_INVITATIONS", user)) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body(Map.of("error", "Not authorized to get invitations"));
            }
            List<InvitationResult> invitations = this.vortexClient.getInvitationsByTarget(targetType, targetValue);
            return ResponseEntity.ok(Map.of("invitations", invitations));
        }
        catch (VortexException e) {
            logger.error("Failed to get invitations by target", (Throwable)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Map.of("error", "Failed to get invitations"));
        }
    }

    @GetMapping(value={"/invitations/{invitationId}"})
    public ResponseEntity<?> getInvitation(@PathVariable(value="invitationId") String invitationId) {
        try {
            VortexConfig.VortexUser user = this.config.authenticateUser();
            if (user == null) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body(Map.of("error", "Authentication required"));
            }
            if (!this.config.authorizeOperation("GET_INVITATION", user)) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body(Map.of("error", "Not authorized to get invitation"));
            }
            InvitationResult invitation = this.vortexClient.getInvitation(invitationId);
            return ResponseEntity.ok((Object)invitation);
        }
        catch (VortexException e) {
            logger.error("Failed to get invitation", (Throwable)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body(Map.of("error", "Invitation not found"));
        }
    }

    @DeleteMapping(value={"/invitations/{invitationId}"})
    public ResponseEntity<?> revokeInvitation(@PathVariable(value="invitationId") String invitationId) {
        try {
            VortexConfig.VortexUser user = this.config.authenticateUser();
            if (user == null) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body(Map.of("error", "Authentication required"));
            }
            if (!this.config.authorizeOperation("REVOKE_INVITATION", user)) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body(Map.of("error", "Not authorized to revoke invitation"));
            }
            this.vortexClient.revokeInvitation(invitationId);
            return ResponseEntity.ok(Map.of("success", true));
        }
        catch (VortexException e) {
            logger.error("Failed to revoke invitation", (Throwable)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Map.of("error", "Failed to revoke invitation"));
        }
    }

    @PostMapping(value={"/invitations/accept"})
    public ResponseEntity<?> acceptInvitations(@RequestBody AcceptInvitationRequest request) {
        try {
            VortexConfig.VortexUser user = this.config.authenticateUser();
            if (user == null) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body(Map.of("error", "Authentication required"));
            }
            if (!this.config.authorizeOperation("ACCEPT_INVITATIONS", user)) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body(Map.of("error", "Not authorized to accept invitations"));
            }
            List<InvitationResult> results = this.vortexClient.acceptInvitations(request.getInvitationIds(), request.getTarget());
            return ResponseEntity.ok(results);
        }
        catch (VortexException e) {
            logger.error("Failed to accept invitations", (Throwable)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Map.of("error", "Failed to accept invitations"));
        }
    }

    @GetMapping(value={"/invitations/by-group/{groupType}/{groupId}"})
    public ResponseEntity<?> getInvitationsByGroup(@PathVariable(value="groupType") String groupType, @PathVariable(value="groupId") String groupId) {
        try {
            VortexConfig.VortexUser user = this.config.authenticateUser();
            if (user == null) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body(Map.of("error", "Authentication required"));
            }
            if (!this.config.authorizeOperation("GET_GROUP_INVITATIONS", user)) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body(Map.of("error", "Not authorized to get group invitations"));
            }
            List<InvitationResult> invitations = this.vortexClient.getInvitationsByGroup(groupType, groupId);
            return ResponseEntity.ok(Map.of("invitations", invitations));
        }
        catch (VortexException e) {
            logger.error("Failed to get group invitations", (Throwable)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Map.of("error", "Failed to get group invitations"));
        }
    }

    @DeleteMapping(value={"/invitations/by-group/{groupType}/{groupId}"})
    public ResponseEntity<?> deleteInvitationsByGroup(@PathVariable(value="groupType") String groupType, @PathVariable(value="groupId") String groupId) {
        try {
            VortexConfig.VortexUser user = this.config.authenticateUser();
            if (user == null) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body(Map.of("error", "Authentication required"));
            }
            if (!this.config.authorizeOperation("DELETE_GROUP_INVITATIONS", user)) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body(Map.of("error", "Not authorized to delete group invitations"));
            }
            this.vortexClient.deleteInvitationsByGroup(groupType, groupId);
            return ResponseEntity.ok(Map.of("success", true));
        }
        catch (VortexException e) {
            logger.error("Failed to delete group invitations", (Throwable)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Map.of("error", "Failed to delete group invitations"));
        }
    }

    @PostMapping(value={"/invitations/{invitationId}/reinvite"})
    public ResponseEntity<?> reinvite(@PathVariable(value="invitationId") String invitationId) {
        try {
            VortexConfig.VortexUser user = this.config.authenticateUser();
            if (user == null) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body(Map.of("error", "Authentication required"));
            }
            if (!this.config.authorizeOperation("REINVITE", user)) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body(Map.of("error", "Not authorized to reinvite"));
            }
            InvitationResult result = this.vortexClient.reinvite(invitationId);
            return ResponseEntity.ok((Object)result);
        }
        catch (VortexException e) {
            logger.error("Failed to reinvite", (Throwable)e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Map.of("error", "Failed to reinvite"));
        }
    }
}

