/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.cache.engine;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.ByteBufferOutputStream;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import dev.voidframework.cache.engine.CacheEngine;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractCacheEngine
implements CacheEngine {
    private final Kryo kryo = new Kryo();

    protected AbstractCacheEngine() {
        this.kryo.setRegistrationRequired(false);
        this.kryo.register(ArrayList.class);
        this.kryo.register(Class.class);
        this.kryo.register(HashMap.class);
        this.kryo.register(HashSet.class);
        this.kryo.register(Optional.class);
    }

    public CachedElement wrap(Object obj) {
        Output output = new Output((OutputStream)new ByteBufferOutputStream());
        Class classType = obj != null ? obj.getClass() : Object.class;
        this.kryo.writeObjectOrNull(output, obj, classType);
        return new CachedElement(classType, output.toBytes());
    }

    public Object unwrap(CachedElement cachedElement) {
        if (cachedElement == null) {
            return null;
        }
        Input input = new Input(cachedElement.content);
        return this.kryo.readObjectOrNull(input, cachedElement.classType);
    }

    protected record CachedElement(Class<?> classType, byte[] content) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CachedElement that = (CachedElement)o;
            return this.classType.equals(that.classType) && Arrays.equals(this.content, that.content);
        }

        @Override
        public int hashCode() {
            int result = Objects.hash(this.classType);
            result = 31 * result + Arrays.hashCode(this.content);
            return result;
        }

        @Override
        public String toString() {
            return "CachedElement{classType='" + this.classType + "', content='<binaryOfLength=" + this.content.length + ">'}";
        }
    }
}

