/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import nu.studer.java.util.OrderedProperties;
import pl.project13.core.CannotReadFileException;
import pl.project13.core.GitCommitIdExecutionException;
import pl.project13.core.log.LogInterface;
import pl.project13.core.util.BuildFileChangeListener;
import pl.project13.core.util.JsonManager;
import pl.project13.core.util.PropertyManager;

public class PropertiesFileGenerator {
    private LogInterface log;
    private BuildFileChangeListener buildFileChangeListener;
    private String format;
    private String prefixDot;
    private String projectName;

    public PropertiesFileGenerator(LogInterface log, BuildFileChangeListener buildFileChangeListener, String format, String prefixDot, String projectName) {
        this.log = log;
        this.buildFileChangeListener = buildFileChangeListener;
        this.format = format;
        this.prefixDot = prefixDot;
        this.projectName = projectName;
    }

    public void maybeGeneratePropertiesFile(@Nonnull Properties localProperties, File base, String propertiesFilename, Charset sourceCharset, boolean escapeUnicode) throws GitCommitIdExecutionException {
        block19: {
            try {
                File gitPropsFile = PropertiesFileGenerator.craftPropertiesOutputFile(base, propertiesFilename);
                boolean isJsonFormat = "json".equalsIgnoreCase(this.format);
                boolean shouldGenerate = true;
                if (gitPropsFile.exists()) {
                    try {
                        Properties persistedProperties;
                        if (isJsonFormat) {
                            this.log.info(String.format("Reading existing json file [%s] (for module %s)...", gitPropsFile.getAbsolutePath(), this.projectName));
                            persistedProperties = JsonManager.readJsonProperties(gitPropsFile, sourceCharset);
                        } else {
                            this.log.info(String.format("Reading existing properties file [%s] (for module %s)...", gitPropsFile.getAbsolutePath(), this.projectName));
                            persistedProperties = PropertyManager.readProperties(gitPropsFile);
                        }
                        Properties propertiesCopy = (Properties)localProperties.clone();
                        String buildTimeProperty = this.prefixDot + "build.time";
                        propertiesCopy.setProperty(buildTimeProperty, "");
                        persistedProperties.setProperty(buildTimeProperty, "");
                        shouldGenerate = !propertiesCopy.equals(persistedProperties);
                    }
                    catch (CannotReadFileException ex) {
                        this.log.info(String.format("Cannot read properties file [%s] (for module %s)...", gitPropsFile.getAbsolutePath(), this.projectName));
                        shouldGenerate = true;
                    }
                }
                if (shouldGenerate) {
                    Files.createDirectories(gitPropsFile.getParentFile().toPath(), new FileAttribute[0]);
                    try (FileOutputStream outputStream = new FileOutputStream(gitPropsFile);){
                        OrderedProperties sortedLocalProperties = PropertiesFileGenerator.createOrderedProperties();
                        localProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> sortedLocalProperties.setProperty((String)key, (String)value)));
                        if (isJsonFormat) {
                            this.log.info(String.format("Writing json file to [%s] (for module %s)...", gitPropsFile.getAbsolutePath(), this.projectName));
                            JsonManager.dumpJson(outputStream, sortedLocalProperties, sourceCharset);
                        } else {
                            this.log.info(String.format("Writing properties file to [%s] (for module %s)...", gitPropsFile.getAbsolutePath(), this.projectName));
                            PropertyManager.dumpProperties(outputStream, sortedLocalProperties, escapeUnicode);
                        }
                    }
                    catch (IOException ex) {
                        throw new RuntimeException("Cannot create custom git properties file: " + gitPropsFile, ex);
                    }
                    if (this.buildFileChangeListener != null) {
                        this.buildFileChangeListener.changed(gitPropsFile);
                    }
                    break block19;
                }
                this.log.info(String.format("Properties file [%s] is up-to-date (for module %s)...", gitPropsFile.getAbsolutePath(), this.projectName));
            }
            catch (IOException e) {
                throw new GitCommitIdExecutionException(e);
            }
        }
    }

    public static OrderedProperties createOrderedProperties() {
        return new OrderedProperties.OrderedPropertiesBuilder().withSuppressDateInComment(true).withOrdering(Comparator.nullsLast(Comparator.naturalOrder())).build();
    }

    public static File craftPropertiesOutputFile(File base, String propertiesFilename) {
        File returnPath = new File(base, propertiesFilename);
        File currentPropertiesFilepath = new File(propertiesFilename);
        if (currentPropertiesFilepath.isAbsolute()) {
            returnPath = currentPropertiesFilepath;
        }
        return returnPath;
    }
}

