/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nu.studer.java.util.OrderedProperties;
import pl.project13.core.CannotReadFileException;

public class PropertyManager {
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static void putWithoutPrefix(@Nonnull Properties properties, String key, String value) {
        if (!PropertyManager.isNotEmpty(value)) {
            value = "Unknown";
        }
        properties.setProperty(key, value);
    }

    private static boolean isNotEmpty(@Nullable String value) {
        return null != value && !" ".equals(value.trim().replaceAll(" ", ""));
    }

    public static Properties readProperties(@Nonnull File propertiesFile) throws CannotReadFileException {
        return PropertyManager.readProperties(propertiesFile, StandardCharsets.ISO_8859_1);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Properties readProperties(@Nonnull File propertiesFile, @Nonnull Charset charset) throws CannotReadFileException {
        try (FileInputStream fis = new FileInputStream(propertiesFile);){
            Properties properties;
            try (InputStreamReader reader = new InputStreamReader((InputStream)fis, charset);){
                OrderedProperties retVal = new OrderedProperties();
                retVal.load((Reader)reader);
                properties = retVal.toJdkProperties();
            }
            return properties;
        }
        catch (Exception ex) {
            throw new CannotReadFileException(ex);
        }
    }

    public static void dumpProperties(OutputStream outputStream, OrderedProperties sortedLocalProperties, boolean escapeUnicode) throws IOException {
        try (OutputStreamWriter outputWriter = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);){
            outputWriter.write("#Generated by Git-Commit-Id-Plugin");
            outputWriter.write(System.getProperty("line.separator"));
            for (Map.Entry e : sortedLocalProperties.entrySet()) {
                String key = PropertyManager.saveConvert((String)e.getKey(), true, escapeUnicode);
                String val = PropertyManager.saveConvert((String)e.getValue(), false, escapeUnicode);
                outputWriter.write(key + "=" + val);
                outputWriter.write(System.getProperty("line.separator"));
            }
        }
    }

    private static String saveConvert(String theString, boolean escapeSpace, boolean escapeUnicode) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer outBuffer = new StringBuffer(bufLen);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    if ((aChar < ' ' || aChar > '~') & escapeUnicode) {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(PropertyManager.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(PropertyManager.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(PropertyManager.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(PropertyManager.toHex(aChar & 0xF));
                        continue block8;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }
}

