/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.boot.runner;

import org.brijframework.boot.context.BootstrapContextImpl;
import org.brijframework.boot.context.args.BootstrapArgs;
import org.brijframework.context.bootstrap.BootstrapContext;
import org.brijframework.factories.impl.AbstractFactory;
import org.brijframework.support.factories.SingletonFactory;
import org.brijframework.util.factories.ReflectionFactory;
import org.brijframework.util.printer.LoggerConsole;
import org.brijframework.util.reflect.InstanceUtil;

public class ApplicationContextRunner
extends AbstractFactory<String, BootstrapContext> {
    private BootstrapArgs arguments = new BootstrapArgs();
    private static ApplicationContextRunner factory;

    private ApplicationContextRunner() {
    }

    @SingletonFactory
    public static ApplicationContextRunner run(String[] varArgs) {
        if (factory == null) {
            factory = new ApplicationContextRunner();
            factory.getArguments().initial(varArgs);
            factory.loadFactory();
        }
        return factory;
    }

    public static ApplicationContextRunner run() {
        return ApplicationContextRunner.run(new String[0]);
    }

    public BootstrapArgs getArguments() {
        return this.arguments;
    }

    public ApplicationContextRunner loadFactory() {
        try {
            LoggerConsole.banner();
            LoggerConsole.screen((String)"Application startup luncher");
            LoggerConsole.screen((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"Lunching the factory to start the ApplicationContext");
            ReflectionFactory.getFactory().getExternalClassList().forEach(applicationContextClass -> {
                if (BootstrapContext.class.isAssignableFrom((Class<?>)applicationContextClass) && InstanceUtil.isAssignable((Class)applicationContextClass)) {
                    BootstrapContext context = (BootstrapContext)InstanceUtil.getInstance((Class)applicationContextClass, (Object[])new Object[0]);
                    context.start();
                    this.register(BootstrapContext.class.getName(), context);
                    this.register(BootstrapContext.class.getSimpleName(), context);
                }
            });
            ReflectionFactory.getFactory().getInternalClassList().forEach(applicationContextClass -> {
                if (BootstrapContextImpl.class.isAssignableFrom((Class<?>)applicationContextClass) && InstanceUtil.isAssignable((Class)applicationContextClass)) {
                    BootstrapContext context = (BootstrapContext)InstanceUtil.getInstance((Class)applicationContextClass, (Object[])new Object[0]);
                    context.start();
                    this.register(BootstrapContext.class.getName(), context);
                    this.register(BootstrapContext.class.getSimpleName(), context);
                }
            });
            LoggerConsole.screen((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"Lunched the factory to start the ApplicationContext");
        }
        catch (Exception e) {
            e.printStackTrace();
            LoggerConsole.screen((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"Error to lunch the factory to start the ApplicationContext");
        }
        LoggerConsole.screen((String)"Application Successfully started");
        return this;
    }

    protected void preregister(String key, BootstrapContext value) {
        LoggerConsole.screen((String)"ApplicationContext", (String)"Lunching the factory to start the ApplicationContext");
    }

    protected void postregister(String key, BootstrapContext value) {
        LoggerConsole.screen((String)"ApplicationContext", (String)"Lunched the factory to start the ApplicationContext");
    }

    public BootstrapContext getApplicationContext() {
        return (BootstrapContext)this.getCache().get(BootstrapContext.class.getName());
    }
}

