/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.accessor;

import org.brijframework.util.asserts.Assertion;
import org.brijframework.util.text.StringUtil;
import org.brijframework.util.validator.ValidationUtil;

public class EventValidateUtil {
    public static final String ADD_PREFIX = "add";
    public static final String REMOVE_PREFIX = "remove";
    public static final String GET_PREFIX = "get";
    public static final String SET_PREFIX = "set";
    public static final String IS_PREFIX = "is";

    public static String setter(String field) {
        Assertion.notNull(field, "this field name is required; it must not be null");
        return SET_PREFIX + StringUtil.capitalFirst(field);
    }

    public static String getter(String field) {
        Assertion.notNull(field, "this field name is required; it must not be null");
        return GET_PREFIX + StringUtil.capitalFirst(field);
    }

    public static String is(String field) {
        Assertion.notNull(field, "this field name is required; it must not be null");
        return IS_PREFIX + StringUtil.capitalFirst(field);
    }

    public static String adder(String field) {
        Assertion.notNull(field, "this field name is required; it must not be null");
        return ADD_PREFIX + StringUtil.capitalFirst(field);
    }

    public static String remover(String field) {
        return REMOVE_PREFIX + StringUtil.capitalFirst(field);
    }

    public static String brijField(String field) {
        if (ValidationUtil.isValidObject((Object)field)) {
            return field;
        }
        return null;
    }

    public static boolean validReader(String method, String field) {
        Assertion.notNull(method, "this method name is required; it must not be null");
        Assertion.notNull(field, "this field name is required; it must not be null");
        return method.contentEquals(EventValidateUtil.getter(field)) || method.contentEquals(EventValidateUtil.is(field));
    }

    public static boolean validWriter(String method, String field) {
        Assertion.notNull(method, "this method name is required; it must not be null");
        Assertion.notNull(field, "this field name is required; it must not be null");
        return method.contentEquals(EventValidateUtil.setter(field)) || method.contentEquals(EventValidateUtil.is(field)) || method.contentEquals(EventValidateUtil.adder(field)) || method.contentEquals(EventValidateUtil.remover(field));
    }
}

