/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.factories;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class FileResourceUtils {
    public static final String REGEX_PATH_SPRTOR = "[/\\\\]";
    public static final String CLASS_EXT = ".class";
    public static final String JAVA_CLASS_PATH = "java.class.path";

    public static List<File> getFiles(String paths) {
        ArrayList<File> filesList = new ArrayList<File>();
        for (String path : paths.split(File.pathSeparator)) {
            File file = new File(path);
            if (file.isDirectory()) {
                FileResourceUtils.recurse(filesList, file);
                continue;
            }
            filesList.add(file);
        }
        return filesList;
    }

    private static void recurse(List<File> filesList, File f) {
        File[] list;
        for (File file : list = f.listFiles()) {
            if (file.isDirectory()) {
                FileResourceUtils.recurse(filesList, file);
                continue;
            }
            filesList.add(file);
        }
    }

    public static List<String> getJarContent(String jarPath) throws IOException {
        ArrayList<String> content = new ArrayList<String>();
        JarFile jarFile = new JarFile(jarPath);
        Enumeration<JarEntry> e = jarFile.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            String name = entry.getName();
            content.add(name);
        }
        return content;
    }

    public static void main(String[] args) throws Exception {
        List<File> list = FileResourceUtils.getFiles(System.getProperty(JAVA_CLASS_PATH));
        for (File file : list) {
            System.out.println(file.getPath());
        }
        list = new ArrayList<File>();
        List<String> content = FileResourceUtils.getJarContent("C:\\Users\\Restart\\.m2\\repository\\com\\fasterxml\\jackson\\core\\jackson-databind\\2.2.2\\jackson-databind-2.2.2.jar");
        for (String file : content) {
            System.out.println(file);
        }
    }
}

