/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.location;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public class TransferUtil {
    public static void moveFile(File moveFrom, File moveTo, boolean isDelete) {
        try {
            FileInputStream rd = new FileInputStream(moveFrom);
            FileOutputStream fo = new FileOutputStream(moveTo);
            while (true) {
                byte[] bytes = new byte[rd.available()];
                rd.read(bytes);
                fo.write(bytes);
                int j = rd.read();
                if (j == -1) break;
                fo.write(j);
            }
            rd.close();
            fo.close();
            if (isDelete) {
                moveFrom.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void moveFile(File moveFrom, File moveTo) {
        try {
            FileInputStream rd = new FileInputStream(moveFrom);
            FileOutputStream fo = new FileOutputStream(moveTo);
            while (true) {
                byte[] bytes = new byte[rd.available()];
                rd.read(bytes);
                fo.write(bytes);
                int j = rd.read();
                if (j == -1) break;
                fo.write(j);
            }
            rd.close();
            fo.close();
            moveFrom.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFileChannel(File sourceFile, File destFile) throws IOException {
        System.out.println("COPY FILE: " + sourceFile.getAbsolutePath() + " TO: " + destFile.getAbsolutePath());
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel sourceChannel = null;
        AbstractInterruptibleChannel destChannel = null;
        try {
            sourceChannel = new FileInputStream(sourceFile).getChannel();
            destChannel = new FileOutputStream(destFile).getChannel();
            sourceChannel.transferTo(0L, sourceChannel.size(), (WritableByteChannel)((Object)destChannel));
        }
        finally {
            if (sourceChannel != null) {
                sourceChannel.close();
            }
            if (destChannel != null) {
                destChannel.close();
            }
        }
    }

    public void copyDirectory(File sourceDir, File destDir) throws IOException {
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        if (!sourceDir.exists()) {
            throw new IllegalArgumentException("sourceDir does not exist");
        }
        if (sourceDir.isFile() || destDir.isFile()) {
            throw new IllegalArgumentException("Either sourceDir or destDir is not a directory");
        }
        File[] items = sourceDir.listFiles();
        if (items != null && items.length > 0) {
            for (File anItem : items) {
                if (anItem.isDirectory()) {
                    File newDir = new File(destDir, anItem.getName());
                    System.out.println("CREATED DIR: " + newDir.getAbsolutePath());
                    newDir.mkdir();
                    this.copyDirectory(anItem, newDir);
                    continue;
                }
                File destFile = new File(destDir, anItem.getName());
                TransferUtil.copyFile(anItem, destFile);
            }
        }
    }

    public static void splitFileWithChunkSize(String mainFileName, int chunkSize) throws Exception {
        int offSetPosition = 0;
        int length = 0;
        boolean flag = true;
        FileOutputStream fileOutputStream = null;
        FileInputStream fileInputStream = new FileInputStream(mainFileName);
        byte[] data = new byte[fileInputStream.available()];
        fileInputStream.read(data);
        while (flag) {
            fileOutputStream = new FileOutputStream("chunk" + offSetPosition + ".txt");
            if (offSetPosition + chunkSize <= data.length) {
                length = chunkSize;
                fileOutputStream.write(data, offSetPosition, length);
                System.out.println(offSetPosition += chunkSize);
                fileOutputStream.flush();
                continue;
            }
            fileOutputStream.write(data, offSetPosition, data.length - offSetPosition);
            fileOutputStream.flush();
            flag = false;
            break;
        }
        fileOutputStream.close();
        fileInputStream.close();
    }

    public static boolean copyFile(File fromFile, File toFile) throws IOException {
        return TransferUtil.moveFileNewWay(fromFile, toFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean moveFileNewWay(File fromFile, File toFile, boolean isDelete) throws IOException {
        boolean isOldDestFileDeletedSuccessfully;
        if (!fromFile.exists()) {
            return false;
        }
        if (toFile.exists() && !(isOldDestFileDeletedSuccessfully = toFile.delete())) {
            return false;
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            boolean bl;
            fileInputStream = new FileInputStream(fromFile);
            fileOutputStream = new FileOutputStream(toFile);
            byte[] bytes = new byte[15000];
            int numberOfBytesRead = fileInputStream.read(bytes);
            while (numberOfBytesRead != -1) {
                fileOutputStream.write(bytes, 0, numberOfBytesRead);
                numberOfBytesRead = fileInputStream.read(bytes);
            }
            fileOutputStream.flush();
            fileInputStream.close();
            if (isDelete) {
                bl = fromFile.delete();
                return bl;
            }
            bl = true;
            return bl;
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {}
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {}
        }
    }
}

