/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.resouces;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Workbook;
import org.brijframework.util.casting.CastingUtil;
import org.brijframework.util.text.StringUtil;
import org.brijframework.util.validator.ValidationUtil;

public class ExcelUtil {
    public static HSSFWorkbook workbook(List<Map<String, Object>> rowList, String[] objectKeys, String[] headerKeys) {
        int i;
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet("Sheet1");
        sheet.createFreezePane(0, 1, 0, 1);
        HSSFRow rowhead = sheet.createRow(0);
        headerKeys = ExcelUtil.validateHeaderWithObjKeys(objectKeys, headerKeys);
        HSSFCellStyle headerCellStyle = ExcelUtil.headerCellStyle(workbook);
        for (int i2 = 0; i2 < headerKeys.length; ++i2) {
            HSSFCell cell = rowhead.createCell(i2);
            cell.setCellValue(ValidationUtil.friendlyNameForJavaVariable(headerKeys[i2]));
            cell.setCellStyle(headerCellStyle);
        }
        HSSFCellStyle dataCellStyle = ExcelUtil.cellStyle(workbook, 12, false, false, IndexedColors.LIGHT_CORNFLOWER_BLUE);
        for (i = 0; i < rowList.size(); ++i) {
            HSSFRow row = sheet.createRow((int)((short)(i + 1)));
            Map<String, Object> map = rowList.get(i);
            for (int j = 0; j < objectKeys.length; ++j) {
                Object rowData = map.get(objectKeys[j]);
                HSSFCell cell = row.createCell(j);
                if (rowData != null) {
                    if (ValidationUtil.isClassANumber(rowData.getClass())) {
                        cell.setCellValue((double)CastingUtil.intValue(rowData));
                    } else {
                        cell.setCellValue(CastingUtil.stringValue(rowData));
                    }
                }
                cell.setCellStyle(dataCellStyle);
            }
        }
        for (i = 0; i < objectKeys.length; ++i) {
            sheet.autoSizeColumn(i);
        }
        return workbook;
    }

    private static String[] validateHeaderWithObjKeys(String[] objectKeys, String[] headerKeys) {
        int i;
        if (headerKeys.length == objectKeys.length) {
            return headerKeys;
        }
        String[] newHeaderKeys = new String[objectKeys.length];
        for (i = 0; i < headerKeys.length; ++i) {
            newHeaderKeys[i] = headerKeys[i];
        }
        for (i = headerKeys.length; i < objectKeys.length; ++i) {
            newHeaderKeys[i] = objectKeys[i];
        }
        return newHeaderKeys;
    }

    public static HSSFWorkbook workbook(List<Map<String, Object>> rowList, String objectKeys, String headerKeys) {
        String[] objectkeyArr = StringUtil.parseTilde(objectKeys);
        String[] headerKeyArr = StringUtil.parseTilde(headerKeys);
        return ExcelUtil.workbook(rowList, objectkeyArr, headerKeyArr);
    }

    public static HSSFWorkbook workbook(List<Map<String, Object>> rowList, String objectKeys) {
        return ExcelUtil.workbook(rowList, objectKeys, objectKeys);
    }

    private static HSSFCellStyle headerCellStyle(HSSFWorkbook workbook) {
        HSSFCellStyle headerCellStyle = ExcelUtil.cellStyle(workbook, 14, true, true, IndexedColors.DARK_BLUE);
        headerCellStyle.setAlignment((short)2);
        headerCellStyle.setVerticalAlignment((short)1);
        headerCellStyle.getFont((Workbook)workbook).setColor((short)9);
        return headerCellStyle;
    }

    private static HSSFCellStyle cellStyle(HSSFWorkbook workbook, int fontSize, boolean isBold, boolean isItalic, IndexedColors bgColor) {
        HSSFCellStyle cellStyle = workbook.createCellStyle();
        HSSFFont font = workbook.createFont();
        font.setFontName("Arial");
        font.setFontHeightInPoints((short)fontSize);
        if (isBold) {
            font.setBoldweight((short)700);
        }
        font.setItalic(isItalic);
        cellStyle.setFont(font);
        cellStyle.setBorderBottom((short)1);
        cellStyle.setBottomBorderColor((short)8);
        cellStyle.setBorderLeft((short)1);
        cellStyle.setLeftBorderColor((short)8);
        cellStyle.setBorderRight((short)1);
        cellStyle.setRightBorderColor((short)8);
        cellStyle.setBorderTop((short)1);
        cellStyle.setTopBorderColor((short)8);
        cellStyle.setFillForegroundColor(bgColor.index);
        cellStyle.setFillPattern((short)1);
        return cellStyle;
    }

    public static void createFile(List<Map<String, Object>> rowList, String objectKeys, String headerKeys, String fileName) {
        HSSFWorkbook workbook = ExcelUtil.workbook(rowList, objectKeys, headerKeys);
        try {
            FileOutputStream fileOut = new FileOutputStream(fileName);
            workbook.write((OutputStream)fileOut);
            fileOut.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void createFile(List<Map<String, Object>> rowList, String objectKeys, String fileName) {
        ExcelUtil.createFile(rowList, objectKeys, objectKeys, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] byteArray(List<Map<String, Object>> rowList, String objectKeys, String headerKeys) {
        HSSFWorkbook workbook = ExcelUtil.workbook(rowList, objectKeys, headerKeys);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            workbook.write((OutputStream)bos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return bos.toByteArray();
    }

    public static byte[] byteArray(List<Map<String, Object>> rowList, String objectKeys) {
        return ExcelUtil.byteArray(rowList, objectKeys, objectKeys);
    }

    public static void main(String[] args) {
        ArrayList<Map<String, Object>> dataArray = new ArrayList<Map<String, Object>>();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("id", "1");
        map.put("name", "ram kishor");
        map.put("email", "ram@mail.com");
        map.put("addres", "noida");
        for (int i = 0; i <= 10; ++i) {
            dataArray.add(map);
        }
        String headerKey = "id~name~email";
        ExcelUtil.createFile(dataArray, headerKey, "data.xls");
    }
}

